/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef Char_h
#define Char_h

#include "charset.h"

/*========================================================================*
 *	ޥ
 *========================================================================*/

#define	CHAR_CHARSET(cc)			(((cc) >> 24) & 0x7F)
#define	CHAR_CODE(cc)				((cc) & 0xFFFF)

#define	Char_IsEqual(chl,chr)		(!Char_Difference ((chl), (chr)))
#define	Char_IsEqualAscii(chl,chr)	(!Char_DifferenceAscii ((chl), (chr)))

/*========================================================================*
 *	
 *========================================================================*/

/*
 *	ʸӥåȤλѾ֤ϼ̤ꡣ
 *		
 *		3130 .. 2423 .. 1615 ... 0
 *		
 *		ʸ          ʸ    
 *		    稭        ɨ
 *		
 */
typedef unsigned long	Char ;

/*========================================================================*
 *	ץȥ
 *========================================================================*/

Char	Char_Make (int nSet, int nCode) ;
Char	Char_MakeAscii (char ch) ;
int		Char_IsAscii (Char cc) ;
int		Char_IsNul (Char cc) ;
int		Char_Is2ByteChara (Char cc) ;
int		Char_DifferenceAscii (Char cc, char ch) ;
int		Char_Difference (Char chLeft, Char chRight) ;
Char	Char_ToLower (Char cc) ;
Char	Char_ToUpper (Char cc) ;

#endif
