;	$B2x$7$$$1$I%7%9%F%`JQ?t$N=i4|2=!#(B

(setq global-map '(keymap
 [set-mark-command		beginning-of-line	backward-char
  mode-specific-command-prefix	delete-char		end-of-line
  forward-char			keyboard-quit		delete-backward-char
  indent-for-tab-command	newline-and-indent	kill-line
  recenter			newline-and-indent	next-line
  open-line			previous-line		quoted-insert
  isearch-backward		isearch-forward		transpose-chars
  universal-argument		scroll-up		kill-region
  Control-X-prefix		yank			scroll-down
  ESC-prefix			toggle-input-method	abort-recursive-edit
  nil				undo			self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		self-insert-command	self-insert-command
  self-insert-command		delete-backward-char]))

(setq im-local-map 
      '(keymap (0 . im-key-filter) (1 . im-key-filter) (2 . im-key-filter)
	       (3 . im-key-filter) (4 . im-key-filter) (5 . im-key-filter)
	       (6 . im-key-filter) (7 . im-key-filter) (8 . im-key-filter)
	       (9 . im-key-filter) (10 . im-key-filter) (11 . im-key-filter) 
	       (12 . im-key-filter) (13 . im-newline) (14 . im-key-filter)
	       (15 . im-key-filter) (16 . im-key-filter) (17 . im-key-filter)
	       (18 . im-key-filter) (19 . im-key-filter) (20 . im-key-filter)
	       (21 . im-key-filter) (22 . im-key-filter) (23 . im-key-filter)
	       (24 . im-key-filter) (25 . im-key-filter) (26 . im-key-filter)
	       (27 . im-key-filter) (28 . im-end-conversion) (29 . im-key-filter)
	       (30 . im-key-filter) (31 . im-key-filter) (127 . im-key-filter)
	       (453050400 . im-end-conversion) (453509216 . im-end-conversion)
	       (t . im-key-notify)))
;(setq im-local-map nil)

(setq minibuffer-local-map 
      '(keymap (13 . exit-minibuffer) (7 . abort-recursive-edit)))

(setq minibuffer-local-completion-map 
      '(keymap (13 . exit-minibuffer) (7 . abort-recursive-edit)))

(setq minibuffer-local-ns-map
      '(keymap (63 . self-insert-and-exit) (9 . exit-minibuffer) (32 . exit-minibuffer) (10 . skk-kakutei) (13 . exit-minibuffer) (7 . abort-recursive-edit)))

(setq mode-line-format '("" "%-"))
;(setq mode-line-format nil)
(setq overwrite-mode nil)
(setq auto-fill-function nil)
(setq unread-command-char -1)
(setq system-type 'unix)
(setq kill-ring nil)
(setq kill-ring-yank-pointer nil)

(defmacro unless (cond &rest body)
  (cons 'if (cons cond (cons nil body))))

(defun backward-word (arg)
  (interactive "vSymbol: ")
  (forward-char))

;(defun backward-word (arg)
;  (interactive "p")
;  (forward-word (- arg)))

(defun kill-word (arg)
  (interactive "p")
  (kill-region (point) (progn (forward-word arg) (point))))

(defun backward-kill-word (arg)
  (interactive "p")
  (kill-word (- arg)))

(defun keyboard-quit ()
  (interactive)
  (signal 'quit nil))

(defvar key-substitution-in-progress nil
 "Used internally by substitute-key-definition.")

(defun substitute-key-definition (olddef newdef keymap &optional oldmap prefix)
  (or prefix (setq prefix ""))
  (let* ((scan (or oldmap keymap))
	 (vec1 (vector nil))
	 (prefix1 (vconcat prefix vec1))
	 (key-substitution-in-progress
	  (cons scan key-substitution-in-progress)))
    ;; Scan OLDMAP, finding each char or event-symbol that
    ;; has any definition, and act on it with hack-key.
    (while (consp scan)
      (if (consp (car scan))
	  (let ((char (car (car scan)))
		(defn (cdr (car scan))))
	    ;; The inside of this let duplicates exactly
	    ;; the inside of the following let that handles array elements.
	    (aset vec1 0 char)
	    (aset prefix1 (length prefix) char)
	    (let (inner-def skipped)
	      ;; Skip past menu-prompt.
	      (while (stringp (car-safe defn))
		(setq skipped (cons (car defn) skipped))
		(setq defn (cdr defn)))
	      ;; Skip past cached key-equivalence data for menu items.
	      (and (consp defn) (consp (car defn))
		   (setq defn (cdr defn)))
	      (setq inner-def defn)
	      ;; Look past a symbol that names a keymap.
	      (while (and (symbolp inner-def)
			  (fboundp inner-def))
		(setq inner-def (symbol-function inner-def)))
	      (if (or (eq defn olddef)
		      ;; Compare with equal if definition is a key sequence.
		      ;; That is useful for operating on function-key-map.
		      (and (or (stringp defn) (vectorp defn))
			   (equal defn olddef)))
		    (define-key keymap prefix1 (nconc (nreverse skipped) newdef))
		(if (and (keymapp defn)
			 ;; Avoid recursively scanning
			 ;; where KEYMAP does not have a submap.
			 (let ((elt (lookup-key keymap prefix1)))
			   (or (null elt)
			       (keymapp elt)))
			 ;; Avoid recursively rescanning keymap being scanned.
			 (not (memq inner-def
				    key-substitution-in-progress)))
		    ;; If this one isn't being scanned already,
		    ;; scan it now.
		    (substitute-key-definition olddef newdef keymap
					       inner-def
					       prefix1)))))
	(if (vectorp (car scan))
	    (let* ((array (car scan))
		   (len (length array))
		   (i 0))
	      (while (< i len)
		(let ((char i) (defn (aref array i)))
		  ;; The inside of this let duplicates exactly
		  ;; the inside of the previous let.
		  (aset vec1 0 char)
		  (aset prefix1 (length prefix) char)
		  (let (inner-def skipped)
		    ;; Skip past menu-prompt.
		    (while (stringp (car-safe defn))
		      (setq skipped (cons (car defn) skipped))
		      (setq defn (cdr defn)))
		    (and (consp defn) (consp (car defn))
			 (setq defn (cdr defn)))
		    (setq inner-def defn)
		    (while (and (symbolp inner-def)
				(fboundp inner-def))
		      (setq inner-def (symbol-function inner-def)))
		    (if (or (eq defn olddef)
			    (and (or (stringp defn) (vectorp defn))
				 (equal defn olddef)))
			(define-key keymap prefix1
			  (nconc (nreverse skipped) newdef))
		      (if (and (keymapp defn)
			       (let ((elt (lookup-key keymap prefix1)))
				 (or (null elt)
				     (keymapp elt)))
			       (not (memq inner-def
					  key-substitution-in-progress)))
			  (substitute-key-definition olddef newdef keymap
						     inner-def
						     prefix1)))))
		(setq i (1+ i))))))
      (setq scan (cdr scan)))))

; This is test code.
(load "skk.el")
(load "skk-trial.el")

(if (not j-skk-mode-invoked)
    ;; enter skk-mode for the first time in this session
    (progn
      (setq j-skk-mode-invoked t)
      ;; modified by Tsugutomo Enami, 1990.8.26
      ;; modified by Masahiko Suzuki, 1992.7.13
      (load (expand-file-name skk-init-file) t)
      (setq j-kakutei-early
	    (and skk-kakutei-early (not skk-process-okuri-early)))
	  (if skk-keep-record
	      (j-create-file
	       skk-record-file
	       "I have created an SKK record file for you."))
	  (or (file-exists-p skkinput-jisyo)
	      (j-create-file
	       skkinput-jisyo
	       "I have created an empty Jisyo file for you."))
      (j-get-file-buffer skkinput-jisyo t)
      (setq j-jisyo-buffer-modified nil)
      (if (file-exists-p skk-jisyo)
	  (j-get-file-buffer skk-jisyo t)
	(setq skk-jisyo-jisyo nil))
      ;; added by Kiyotaka Sakai, 1994.6.14.
      (or (fboundp 'string-width)
	  (fset 'string-width (symbol-function 'length)))
      (if skk-use-vip
	  (progn
	    ;; we should be able to use (require 'vip) eventually.
	    (if (not (boundp 'vip-current-mode)) (load "vip"))
	    ;; check vip's version.  this modification will not be
	    ;; necessary for vip4.x.
	    (if (string= (vip-version)
			 "VIP version 3.5 of September 15, 1987")
		(progn
		  (message "")
		  (fset 'vip-change-mode 'vip-ch-mode)))))))
;(princ j-jisyo-okuri-info)
;(load (expand-file-name skk-init-file) t)
;(j-get-file-buffer skkinput-jisyo t)
;(setq j-jisyo-buffer-modified nil)

(defun im-auto-send-text ()
  (if (or j-henkan-on j-henkan-active)
      (let ((pos (min (point) j-kana-start-point (1- j-henkan-start-point))))
	(if (< (point-min) pos)
	    (progn 
	      (im-send-text im-client (buffer-substring (point-min) pos))
	      (delete-region (point-min) pos))))
    (let ((pos
	   (if (> (length j-prefix) 0)
	       (min (point) j-kana-start-point)
	     (point))))
      (if (< (point-min) pos)
	  (progn 
	    (im-send-text im-client (buffer-substring (point-min) pos))
	    (delete-region (point-min) pos))))))

(defun im-newline (arg)
  (interactive "p")
  (if j-mode
      (let ((no-nl (and skk-egg-like-newline j-henkan-on)))
	(if (j-in-minibuffer)
	    (progn
	      (j-kakutei)
	      (if no-nl
		  nil
		(setq j-mode nil)
		(exit-minibuffer)))
	  (if (j-kakutei) (setq arg (1- arg)))
	  (if no-nl
	      nil
	    (let ((str (buffer-string)))
	      (if (> (length str) 0)
		  (im-send-text im-client str))
	      (im-send-text im-client "\n")
	      (erase-buffer)))))
    (let ((str (buffer-string)))
      (if (> (length str) 0)
	  (im-send-text im-client str))
      (im-send-text im-client "\n")
      (erase-buffer))))

(defun im-end-conversion (arg)
  (interactive "p")
  (im-send-end-conversion im-client))

(defun im-key-notify (arg)
  (interactive "p")
; $BJ8;z$,F~$C$F$$$k;~$K8z2L$,$"$k$h$&$K$9$k$Y$-$+H]$+!#(B
; (if (= (point-min) (point-max)) $B$rDI2C$9$k$+$I$&$+!"$G$9$,!#(B
  (im-send-key im-client last-command-event))

(defun im-key-filter (arg)
  (interactive "p")
  (let ((prefix-arg arg)
	(local-map (current-local-map))
	(keys (j-command-key-sequence (this-command-keys) this-command))
	(buf (current-buffer)))
    (if (= (point-min) (point-max))
	(im-send-key im-client last-command-event)
      (if (null keys)
	  ;; no alternative commands.  may be invoked by M-x.
	  nil
	(unwind-protect
	    (progn
	      (use-local-map nil)
	      (let ((command (j-key-binding keys)))
		(if (eq command this-command)
		    ;; avoid recursive calling of j-emulate-original-map.
		    nil
		  ;; if no bindings are found, call `undefined'.  it's
		  ;; original behaviour.
		  ;; $B$G$b!"(Bcondition-case $B$G=&$o$J$+$C$?$i!"(Blocal-map
		  ;; $B$,I|85$G$-$J$/$F:$$C$F$7$^$&!#(B
		  (setq this-command (or command (function undefined)))
		  (condition-case nil
		      (command-execute this-command)
		    (error nil)))))
	  ;; restore skk keymap.
	  (save-excursion
	    (set-buffer buf)
	    (use-local-map local-map)))))))


