/* # skkinput (Simple Kana-Kanji Input)
 * OverWinP.h --- Over The Spot Window Style
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef OnWinP_h
#define OnWinP_h

#include "commondef.h"
#include "buffers.h"
#include "skkbuf.h"
#include "skkkey.h"
#include "OnWin.h"
#include "HistMgr.h"
#include "FontMgr.h"
#include "attrs.h"
#include <X11/CoreP.h>

typedef struct {
	Pixel					puppixel ;
	String					fontset_string ;
	struct skkinputManagedFont*	fontset [NUMBER_OF_CHARSET] ;
	String					minibuf_fontset_string ;
	struct skkinputManagedFont*	minibuf_fontset [NUMBER_OF_CHARSET] ;
	GC						minibuf_gc, minibuf_rgc ;
	int						font_height, font_ascent ;
	int						mfont_height, mfont_ascent ;
	int						cursor_width ;
	Dimension				minibuf_width ;
	Boolean					reverse_video ;
	Boolean					change_minibuffer_font ;
	Boolean					overthespotLikeInput ;
	Colormap				colormap ;
	Pixel					foreground, background ;
	Pixel					oforeground, obackground ;
	Boolean					clearMinibuffer ;
	
	Window 					client_window ;
	unsigned long			attribute_mask ;
	int						conversion_set_focus, conversion_unset_focus ;

	int						modeshell_probe ;
	String					modeshell_geometry;	
	unsigned long			prevModeStatus ;

	Widget					minibuffer_popup, minibuffer_canvas ;
	int						minibuffer_probe ;
	
	Window					minibuffer_win ;
	int						minibuffer_ofstx ;

	struct myChar			m_strModeText [16] ;
	int						m_nModeTextLen ;

	struct myChar			m_strPreeditText [TEXTBUFSIZE] ;
	int						m_nPreeditCaret ;
	Boolean					m_fPreeditActive ;
	Boolean					m_fActive ;
	Boolean					m_fInputFocus ;

	struct ConvAttrsMesg*	camsg ;
	
	XtCallbackList			m_lstCbkPreeditStart ;
	XtCallbackList			m_lstCbkPreeditDraw ;
	XtCallbackList			m_lstCbkPreeditCaret ;
	XtCallbackList			m_lstCbkPreeditDone ;
	XtCallbackList			m_lstCbkStatusStart ;
	XtCallbackList			m_lstCbkStatusDone ;
	XtCallbackList			m_lstCbkStatusDraw ;
	XtCallbackList			m_lstTextCallback ;

	XtCallbackList			endcallback ;
	XtCallbackList			fixcallback ;
	XtCallbackList			keybackcallback ;

	HistoryListNode*		historyAttribute ;

	/* skkinput  buffer */
	struct skkinputBuffer	buffer ;
}	OnthespotWinPart ;

typedef struct _OnthespotWinRec {
	CorePart 			core ;
	OnthespotWinPart	onthespotWin ;
}	OnthespotWinRec ;

typedef struct {
	int dummy ;
}	OnthespotWinClassPart ;

typedef struct _OnthespotWinClassRec {
	CoreClassPart			core_class ;
	OnthespotWinClassPart	onthespotWin_class ;
}	OnthespotWinClassRec ;

extern OnthespotWinClassRec onthespotWinClassRec ;

#endif
