<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
//                   This module; Copyright (c) 2005 suin                    //
//                          <http://www.suin.jp>                             //
//  ------------------------------------------------------------------------ //

if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

require_once XOOPS_ROOT_PATH."/class/xoopsobject.php";

define("DB_HAKUSHU_LOG", "hakushu_log");

class HakushuLog extends XoopsObject{

	var $db;

	function HakushuLog($id=null)
	{
		// * key	string	
		// * data-type	int	
		//   +  1 - XOBJ_DTYPE_TXTBOX | 2 - XOBJ_DTYPE_TXTAREA | 3 - XOBJ_DTYPE_INT
		//   +  4 - XOBJ_DTYPE_URL    | 5 - XOBJ_DTYPE_EMAIL   | 6 - XOBJ_DTYPE_ARRAY
		//   +  7 - XOBJ_DTYPE_OTHER  | 8 - XOBJ_DTYPE_SOURCE  | 9 - XOBJ_DTYPE_STIME
		//   +  10 - XOBJ_DTYPE_MTIME | 11 - XOBJ_DTYPE_LTIME
		// * value	mixed	
		// * required	bool	require html form input?
		// * maxlength	int 	for XOBJ_DTYPE_TXTBOX type only.
		// * options	string	does this data have any select options?

		$this->db =& Database::getInstance();
		$this->initVar("id",        XOBJ_DTYPE_INT,     null, false      );
		$this->initVar("uid",       XOBJ_DTYPE_INT,     null, false      );
		$this->initVar("time",      XOBJ_DTYPE_INT,     null, false      );
		$this->initVar("comment",   XOBJ_DTYPE_TXTBOX,  null, false, 200 );
		$this->initVar("ip",        XOBJ_DTYPE_TXTBOX,  null, false, 15  );


		if ( !empty($id) ) {
			if ( is_array($id) ) {
				$this->assignVars($id);
			} else {
				$this->load(intval($id));
			}
		}
	}

	function load($id)
	{
		$sql = "SELECT * FROM ".$this->db->prefix(DB_HAKUSHU_LOG)." WHERE id=".$id."";
		$myrow = $this->db->fetchArray($this->db->query($sql));
		$this->assignVars($myrow);
	}

	function store()
	{
		if ( !$this->cleanVars() ) {
			return false;
		}

		$ins_into = "" ;
		$ins_set  = "" ;
		$upd_set  = "" ;
		foreach ( $this->cleanVars as $k=>$v ) {
			$$k = $v;
			if( $k == 'id' ) continue;
			$ins_into .= "$k, " ;
			$ins_set .= $this->db->quoteString($v)." ," ;
			$upd_set .= $k."=".$this->db->quoteString($v).", " ;
		}
		$ins_into = substr($ins_into, 0, -2);
		$ins_set  = substr($ins_set, 0, -2);
		$upd_set  = substr($upd_set, 0, -2);

		if ( empty($id) ) {
			$id = $this->db->genId($this->db->prefix(DB_HAKUSHU_LOG)."_id_seq");
			$sql = "INSERT INTO ".$this->db->prefix(DB_HAKUSHU_LOG)." (".$ins_into.") VALUES (".$ins_set.")";
		} else {
			$sql ="UPDATE ".$this->db->prefix(DB_HAKUSHU_LOG)." SET ".$upd_set." WHERE id=".$this->getVar('id');
		}

		//echo $sql;

		if ( !$result = $this->db->query($sql) ) {
			$this->setErrors("Could not store data in the database.");
			return false;
		}

	        if (empty($id)) {
			$id = $this->db->getInsertId();
	        }

	        $this->assignVar('id', $id);

	        return true;
	}

	function delete()
	{
		$sql = sprintf("DELETE FROM %s WHERE id = %u", $this->db->prefix(DB_HAKUSHU_LOG), $this->getVar("id"));
        	if ( !$this->db->query($sql) ) {
			return false;
		}
		return true;
	}

	function &getAll($criteria=array(), $asobject=true, $orderby="id DESC", $limit=0, $start=0)
	{
		$db =& Database::getInstance();
		$ret = array();
		$where_query = "";
		if ( is_array($criteria) && count($criteria) > 0 ) {
			$where_query = " WHERE";
			foreach ( $criteria as $c ) {
				$where_query .= " $c AND";
			}
			$where_query = substr($where_query, 0, -4);
		}
		if ( !$asobject ) {
			$sql = "SELECT id FROM ".$db->prefix(DB_HAKUSHU_LOG)."$where_query ORDER BY $orderby";
			$result = $db->query($sql,intval($limit),intval($start));
			while ( $myrow = $db->fetchArray($result) ) {
				$ret[] = $myrow['id'];
			}
		} else {
			$sql = "SELECT * FROM ".$db->prefix(DB_HAKUSHU_LOG)."".$where_query." ORDER BY $orderby";
			$result = $db->query($sql,$limit,$start);
			while ( $myrow = $db->fetchArray($result) ) {
				$ret[] = new HakushuLog($myrow);
			}
		}
		//echo $sql;
		return $ret;
	}

	function CountAll(){
		$db =& Database::getInstance();
		$sql = "SELECT COUNT(*) FROM ".$db->prefix(DB_HAKUSHU_LOG);
		//echo $sql;
		list($numrows) = $db->fetchRow($db->query($sql));
		return $numrows;
	}

	function getLastClap($ip){
		$db =& Database::getInstance();
		$sql = "SELECT time FROM ".$db->prefix(DB_HAKUSHU_LOG)." WHERE ip=".$db->quoteString($ip)." ORDER BY `time` DESC";
		//echo $sql;
		list($time) = $db->fetchRow($db->query($sql, 1, 0));
		return $time;
	}

	function getUname()
	{
		//XoopsUser饹
		$member_handler =& xoops_gethandler('member');
		$thisUser =& $member_handler->getUser($this->getVar('uid'));

		$uname = $GLOBALS['xoopsConfig']['anonymous'];
		//桼¸ߤ
		if (is_object($thisUser) && $thisUser->isActive()) {
			$uname = $thisUser->getVar('uname');
		}
		return $uname;
	}

	function getDate( $timeformat = 'Y-m-d')
	{
		return formatTimestamp( $this->getVar('time'), $timeformat );
	}

}
?>