<?php
/**
* FlatFiles - operowanie na plikach jako bazach danych
* @access   public 
* @version  0.1.5
* @require  FileJobs
* @require  Trash
*/
class FlatFiles extends FileJobs
{
	var $row;
	var $txt;
  var $string;
	var $seperator  =	'$';
	var $break      = "\n";
  var $rFile;

  /**
  * Przydzielanie array'a do wlasciwosci
  * @return void
  * @param array $aData
  */
  function setRow( $aData ){
    $this->row = $aData;
  } // end function setRow

  /**
  * Przydzielanie stringa do wlasciwosci
  * @return void
  * @param string $sText
  */
  function setString( $sText ){
    $this->string = $sText;
  } // end function setString

	/**
  * Otwarcie pliku
  * @return int
  * @param string $sAtrybut
  */
	function openFile( $sAtrybut ){
		$this->rFile = fopen( $this->fileName, $sAtrybut );
	} // end function openFile
	
	/**
  * Zamkniecie pliku
  * @return void
  */
	function closeFile( ){
		fclose( $this->rFile );
	} // end function closeFile

  /**
  * Dodawanie danych do pliku
  * @return bool
  * @param string $sFile
  * @param string $opcja
  * @param string $sAtrybut
  */
  function addToFile( $sFile = null, $opcja = 'end', $sAtrybut = 'a' ){
		
		if( isset( $sFile ) )
			$this->setFileName( $sFile );	

		if( $opcja == 'end' ){
			$this->openFile( $sAtrybut );
			$return = $this->addToEnd( );
		}
		else
			$return = $this->addToTop( );
		
		$this->closeFile( );
		
		unset( $this->row );
		unset( $this->string );
		
		return $return;
	} // end function addToFile

  /**
  * Dodawanie danych do poczatku pliku
  * @return bool
  */
  function addToTop( ){

    $rowFile =  file( $this->fileName );
    $this->openFile( 'w' );

		if( isset( $this->row ) && is_array( $this->row ) )
			$this->txt = implode( $this->seperator, $this->row ).$this->seperator;
		else 
			$this->txt = $this->string;
      
    $this->txt .= $this->break;
    $count = count( $rowFile );

    for( $lp = 0; $lp < $count; $lp++ )
      $this->txt .= $rowFile[$lp];

		if( fwrite( $this->rFile, $this->txt ) )
			return true;
		else
			return false;

  } // end function addToTop

  /**
  * Dodawanie danych do konca pliku
  * @return bool
  */
	function addToEnd( ){

		if( isset( $this->row ) && is_array( $this->row ) )
			$this->txt = implode( $this->seperator, $this->row ).$this->seperator;
		else 
			$this->txt = $this->string;

    if( fwrite( $this->rFile, $this->txt.$this->break ) )
			return true;
		else
			return false;
	} // end function addToEnd

  /**
  * Zwracanie ostatniego id z pliku
  * @return int
  * @param string $sFile
  * @param int    $iPosition
  * @param int    $iExpLimit
  */
  function throwLastId( $sFile, $iPosition = 1, $iExpLimit = 20 ){

    $this->setFileName( $sFile );	

    if( is_file( $this->fileName ) ){
      $aFile =  file( $this->fileName );
      $iCount = count( $aFile );

      if( $this->throwExtOfFile( $this->fileName ) == 'php' )
        $iStart = 1;
      else
        $iStart = 0;

      $aExp[$iPosition] = 0;

      if( $iCount > $iStart )
        $aExp = explode( '$', $aFile[$iCount-1], $iExpLimit );

      return $aExp[$iPosition];
    }
    else
      return null;
  } // end function throwLastId


  /**
  * Zwracanie zawartosci pliku w postaci array'a
  * @return array
  * @param string $sFile
  * @param string $sSort
  * @param int    $iEol
  */
  function throwFileArray( $sFile = null, $sSort = null, $iEol = 20000 ){		
    if( isset( $sFile ) )
			$this->setFileName( $sFile );

    $this->openFile( 'r' );

    if( $this->throwExtOfFile( $this->fileName ) == 'php' )
      $iStart = 1;
    else
      $iStart = 0;
    
    $i = 0;
    
    while( ( $aFile = fgetcsv( $this->rFile, $iEol, $this->seperator ) ) !== FALSE ){
      if( $i >= $iStart ){
        $aData[] = $aFile;
      }
      $i++;
    }
    
    $this->closeFile( );

    if( isset( $aData ) ){
      if( isset( $sSort ) )
        $sSort( $aData );
      return $aData;
    }
    else
      return null;
  } // end function throwFileArray

  /**
  * Zwracanie zawartosci pliku w postaci array'a oraz podzial na strony
  * @return array
  * @param string $sFile
  * @param string $sSort
  * @param int    $iPage
  * @param int    $iMax
  * @param int    $iExpLimit
  */
  function throwFileArrayPages( $sFile = null, $sSort = null, $iPage = null, $iMax = 20, $iExpLimit = 20 ){

    if( isset( $sFile ) )
			$this->setFileName( $sFile );

    $aFile = file( $this->fileName );

    $iCount =     count( $aFile );
    $iFindPage =  0;
    $iFindAll =   0;

    if( isset( $sSort ) )
      $sSort( $aFile );

    if( $this->throwExtOfFile( $this->fileName ) == 'php' )
      $iStart = 1;
    else
      $iStart = 0;

    for( $i = $iStart; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i], $iExpLimit );
      $iFindPage++;
      $iFindAll++;
      
      if( $iFindPage == 1 )
        $aPageStart[] = $i;

      if( isset( $aPageStart[$iPage - 1] ) && !isset( $aPageEnd[$iPage - 1] ) ){
        $aData[] = $aExp;
      }

      if( $iFindPage == $iMax ){
        $aPageEnd[] = $i;
        $iFindPage =  0;
      }
    } // end for

    if( isset( $aData ) ){
      $aData[0]['iFindAll'] = $iFindAll;
      return $aData;
    }
    else
      return null;
  } // end function throwFileArrayPages

  /**
  * Zwracanie zawartosci pliku w postaci array'a po spelnieniu warunku if oraz podzial na strony
  * @return array
  * @param string $sFile
  * @param string $sSort
  * @param int    $iPage
  * @param int    $iMax
  * @param int    $iVerifyIndex
  * @param int    $mValue
  * @param int    $iExpLimit
  */
  function throwFileArrayClausePages( $sFile = null, $sSort = null, $iPage = null, $iMax = 20, $iVerifyIndex, $mValue, $iExpLimit = 20 ){

    if( isset( $sFile ) )
			$this->setFileName( $sFile );

    $aFile = file( $this->fileName );

    $iCount =     count( $aFile );
    $iFindPage =  0;
    $iFindAll =   0;

    if( isset( $sSort ) )
      $sSort( $aFile );

    if( $this->throwExtOfFile( $this->fileName ) == 'php' )
      $iStart = 1;
    else
      $iStart = 0;

    for( $i = $iStart; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i], $iExpLimit );
      if( $aExp[$iVerifyIndex] == $mValue ){
        $iFindPage++;
        $iFindAll++;
        
        if( $iFindPage == 1 )
          $aPageStart[] = $i;

        if( isset( $aPageStart[$iPage - 1] ) && !isset( $aPageEnd[$iPage - 1] ) ){
          $aData[] = $aExp;
        }

        if( $iFindPage == $iMax ){
          $aPageEnd[] = $i;
          $iFindPage =  0;
        }
      }
    } // end for

    if( isset( $aData ) ){
      $aData[0]['iFindAll'] = $iFindAll;
      return $aData;
    }
    else
      return null;
  } // end function throwFileArrayClausePages

  /**
  * Zwracanie zawartosci pliku w postaci array'a po spelnieniu warunku if
  * @return array
  * @param string $sFile
  * @param string $sSort
  * @param int    $iVerifyIndex
  * @param int    $mValue
  * @param int    $iEol
  */
  function throwFileArrayClause( $sFile = null, $sSort = null, $iVerifyIndex, $mValue, $iEol = 20000 ){
		
    if( isset( $sFile ) )
			$this->setFileName( $sFile );

    $this->openFile( 'r' );
    
    if( $this->throwExtOfFile( $this->fileName ) == 'php' )
      $iStart = 1;
    else
      $iStart = 0;
    
    $i = 0;
    
    while( ( $aFile = fgetcsv( $this->rFile, $iEol, $this->seperator ) ) !== FALSE ){
      if( $i >= $iStart && $aFile[$iVerifyIndex] == $mValue ){
        $aData[] = $aFile;
      }
      $i++;
    }
    
    $this->closeFile( );
    
    if( isset( $aData ) ){
      if( isset( $sSort ) )
        $sSort( $aData );
      return $aData;
    }
    else
      return null;
 
  } // end function throwFileArrayClause

  /**
  * Zwracanie zawartosci pliku w postaci array'a z wybranymi polami.
  * @return array
  * @param string $sFile
  * @param string $sSort
  * @param int    $iIndexFirst - index array'a
  * @param int    $iIndexSecond - index wartosci array'a
  * @param int    $iEol
  */
  function throwFileArraySmall( $sFile = null, $sSort = null, $iIndexFirst = 0, $iIndexSecond = 1, $iEol = 20000 ){
		
    if( isset( $sFile ) )
			$this->setFileName( $sFile );

    $this->openFile( 'r' );
    
    if( $this->throwExtOfFile( $this->fileName ) == 'php' )
      $iStart = 1;
    else
      $iStart = 0;
    
    $i = 0;
    
    while( ( $aFile = fgetcsv( $this->rFile, $iEol, $this->seperator ) ) !== FALSE ){
      if( $i >= $iStart ){
        $aData[$aFile[$iIndexFirst]] = changeTxt( $aFile[$iIndexSecond] );
      }
      $i++;
    }
    
    $this->closeFile( );
    
    if( isset( $aData ) ){
      if( isset( $sSort ) )
        $sSort( $aData );
      return $aData;
    }
    else
      return null; 
  } // end function throwFileArraySmall

  /**
  * Zwracanie danych z pliku
  * @return array
  * @param string $sFile
  * @param mixed  $mValue
  * @param int    $iPosition
  * @param int    $iEol
  */
  function throwData( $sFile = null, $mValue, $iPosition = 0, $iEol = 20000 ){
		if( isset( $sFile ) )
			$this->setFileName( $sFile );	

    $this->openFile( 'r' );

    if( $this->throwExtOfFile( $this->fileName ) == 'php' )
      $iStart = 1;
    else
      $iStart = 0;
    
    $i = 0;
    
    while( ( $aFile = fgetcsv( $this->rFile, $iEol, $this->seperator ) ) !== FALSE ){
      if( $i >= $iStart && $aFile[$iPosition] == $mValue ){
        $aReturn = $aFile;
      }
      $i++;
    }
    
    $this->closeFile( );
    
    if( isset( $aReturn ) ){
      return $aReturn;
    }
    else{
      return null; 
    }
  } // end function throwData

  /**
  * Zwracanie danych z pliku w postaci select'a
  * @return string
  * @param string $sFile
  * @param int    $iId
  * @param int    $iVerify - index tablicy do porownania z $iId
  * @param int    $iValue - wartosc wyswietlana w optionie
  * @param int    $iName - nazwa wyswietlana w optionie
  * @param int    $iEol
  */
  function throwFileSelect( $sFile = null, $iId, $iVerify = 0, $iValue = 0, $iName = 1, $iEol = 20000 ){
		if( isset( $sFile ) )
			$this->setFileName( $sFile );	

    $this->openFile( 'r' );

    if( $this->throwExtOfFile( $this->fileName ) == 'php' )
      $iStart = 1;
    else
      $iStart = 0;
    
    $i        = 0;
    $sOption  = null;
    
    while( ( $aFile = fgetcsv( $this->rFile, $iEol, $this->seperator ) ) !== FALSE ){
      if( $i >= $iStart ){
        if( isset( $iId ) && $aFile[$iVerify] == $iId )
          $sSelected = 'selected="selected"';
        else
          $sSelected = null;
  
        $sOption .= '<option value="'.$aFile[$iValue].'" '.$sSelected.' >'.$aFile[$iName].'</option>';
      }
      $i++;
    }
    
    $this->closeFile( );

    return $sOption;  
  } // end function throwDataSelect

  /**
  * Usuwanie danych z pliku
  * @return bool
  * @param string $sFile
  * @param mixed  $mValue
  * @param int    $iPosition
  */
  function deleteInFile( $sFile = null, $mValue, $iPosition = 0 ){
		
		if( isset( $sFile ) )
			$this->setFileName( $sFile );	

    if( $this->throwExtOfFile( $this->fileName ) == 'php' )
      $iStart = 0;
    else
      $iStart = -1;

    $bFound = null;

    $aFile =  file( $this->fileName );
    $iCount = count( $aFile );
    $this->openFile( 'w' );

    for( $i = 0; $i < $iCount; $i++ ){
      if( $i > $iStart ){
        $aExp = explode( '$', $aFile[$i] );
        if( $aExp[$iPosition] == $mValue ){
          $aFile[$i] = null;
          $bFound = true;
        }
      }
      fwrite( $this->rFile, $aFile[$i] );
    } // end for
  	
		
		$this->closeFile( );		
		return $bFound;
	} // end function deleteInFile

  /**
  * Zmienianie danych w pliku
  * @return bool
  * @param string $sFile
  * @param mixed  $mValue
  * @param int    $iPosition
  */
  function changeInFile( $sFile = null, $mValue, $iPosition = 0 ){
		
		if( isset( $sFile ) )
			$this->setFileName( $sFile );	

    if( $this->throwExtOfFile( $this->fileName ) == 'php' )
      $iStart = 0;
    else
      $iStart = -1;

    $bFound = null;

    if( isset( $this->row ) && is_array( $this->row ) )
			$this->txt = implode( $this->seperator, $this->row ).'$';
		else 
			$this->txt = $this->string;

    $this->txt .= $this->break;

    $aFile =  file( $this->fileName );
    $iCount = count( $aFile );
    $this->openFile( 'w' );

    for( $i = 0; $i < $iCount; $i++ ){
      if( $i > $iStart ){
        $aExp = explode( '$', $aFile[$i] );
        if( $aExp[$iPosition] == $mValue ){
          $aFile[$i] = $this->txt;
          $bFound = true;
        }
      }
      fwrite( $this->rFile, $aFile[$i] );
    } // end for
  	
		
		$this->closeFile( );
		
		unset( $this->row );
		unset( $this->string );
		
		return $bFound;
	} // end function changeInFile
};
?>
