<?php

if( !function_exists( 'throwOrdersIdTemp' ) ){
  /**
  * Zwrocenie id zamowienia tymczasowego
  * jesli zamowienie nie istnieje to nastepuje jego dodanie
  * @return int
  * @param int    $iClient
  * @param string $sOption
  */
  function throwOrdersIdTemp( $iClient, $sOption = 'add' ){
    return dbThrowOrdersIdTemp( $iClient, $sOption );
  } // end function throwOrdersIdTemp
}

if( !function_exists( 'throwOrder' ) ){
  /**
  * Zwracanie danych zamowienia
  * @return array
  * @param int  $iOrder
  */
  function throwOrder( $iOrder ){
    $aData =  dbThrowOrder( $iOrder );

    if( isset( $aData ) ){
      
      //for japanese
      //$aOrder['id']              =JcodeConvert($aOrder['id'],0,1);
      //$aOrder['iKlient']         =JcodeConvert($aOrder['iKlient'],0,1);
      //$aOrder['iStatus']         =JcodeConvert($aOrder['iStatus'],0,1);
      //$aOrder['iCourier']        =JcodeConvert($aOrder['iCourier'],0,1);
      $aOrder['sFirstName']      =JcodeConvert($aOrder['sFirstName'],0,1);
      $aOrder['sLastName']       =JcodeConvert($aOrder['sLastName'],0,1);
      $aOrder['sCompanyName']    =JcodeConvert($aOrder['sCompanyName'],0,1);
      $aOrder['sStreet']         =JcodeConvert($aOrder['sStreet'],0,1);
      $aOrder['sZipCode']        =JcodeConvert($aOrder['sZipCode'],0,1);
      $aOrder['sCity']           =JcodeConvert($aOrder['sCity'],0,1);
      //$aOrder['sTelephone']      =JcodeConvert($aOrder['sTelephone'],0,1);
      //$aOrder['sEmail']          =JcodeConvert($aOrder['sEmail'],0,1);
      //$aOrder['iTime']           =JcodeConvert($aOrder['iTime'],0,1);
      //$aOrder['sIp']             =JcodeConvert($aOrder['sIp'],0,1);
      $aOrder['sComment']        =JcodeConvert($aOrder['sComment'],0,1);
      //

      list( $aOrder['id'], $aOrder['iKlient'], $aOrder['iStatus'], $aOrder['iCourier'], $aOrder['sFirstName'], $aOrder['sLastName'], $aOrder['sCompanyName'], $aOrder['sStreet'], $aOrder['sZipCode'], $aOrder['sCity'], $aOrder['sTelephone'], $aOrder['sEmail'], $aOrder['iTime'], $aOrder['sIp'], $aOrder['sComment'] ) = $aData;

      $aOrder          =  changeMassTxt( $aOrder, '' );
      $aOrder['sDate'] =  date( 'Y-m-d H:i:s', $aOrder['iTime'] );

      return $aOrder;
    }
    else
      return null;
  } // end function throwOrder
}

if( !function_exists( 'checkBasketProducts' ) ){
  /**
  * Sprawdzanie produktow w koszyku
  * @return void
  * @param int  $iOrder
  */
  function checkBasketProducts( $iOrder ){
    return dbCheckBasketProducts( $iOrder );
  } // end function checkBasketProducts
}

if( !function_exists( 'addBasketProduct' ) ){
  /**
  * Dodawanie produktu do basketa
  * @return void
  * @param int  $iProduct
  * @param int  $iQuantity
  */
  function addBasketProduct( $iProduct, $iQuantity ){
    $aProduct = throwProduct( $iProduct );
    if( isset( $aProduct ) ){
      $iOrder = throwOrdersIdTemp( $_SESSION['iCustomer'] );
      dbAddBasketProduct( $aProduct, $iQuantity, $iOrder );
    }
  } // end function addBasketProduct
}

if( !function_exists( 'delBasketElement' ) ){
  /**
  * Usuwanie elementu zamowienia
  * @return void
  * @param int  $iOrder
  * @param int  $iElement
  */
  function delBasketElement( $iOrder, $iElement = null ){
    dbDelBasketElement( $iOrder, $iElement );
  } // end function delBasketElement
}

if( !function_exists( 'delOrder' ) ){
  /**
  * Usuwanie zamowienia
  * @return void
  * @param int  $iOrder
  */
  function delOrder( $iOrder ){
    dbDelOrder( $iOrder );
    delBasketElement( $iOrder );
  } // end function delOrder
}

if( !function_exists( 'listBasket' ) ){
  /**
  * Wyswietlanie zawartosci basketa
  * @return string
  * @param int    $iOrder
  * @param string $sFile
  */
  function listBasket( $iOrder, $sFile = 'orders_basket.tpl' ){
    global $tpl, $aBasket;
    
    $aData      = dbListBasket( $iOrder );

    if( isset( $aData ) ){
      $iCount   = count( $aData );
      $i2       = 0;
      $fSummary = 0;
      $content  = null;

      $aProducts = throwProducts( );

      for( $i = 0; $i < $iCount; $i++ ){
        list( $aBasket['iElement'], $aBasket['iOrder'], $aBasket['iProduct'], $aBasket['iQuantity'], $aBasket['fPrice'] ) = $aData[$i];
        
        if( $i % 2 )
          $aBasket['style'] = 'order_table_data_even';
        else
          $aBasket['style'] = 'order_table_data_odd';

        if( isset( $aProducts[$aBasket['iProduct']] ) )
          $aBasket['sName'] = $aProducts[$aBasket['iProduct']];
        else
          $aBasket['sName'] = null;

        $aBasket['fSummary']  = tPrice( $aBasket['iQuantity'] * $aBasket['fPrice'] );

        $fSummary +=  $aBasket['fSummary'];

        $content .= $tpl->tbHtml( $sFile, 'LIST_LIST' );
      } // end for

      $aBasket['fSummary'] = tPrice( $fSummary );

      return $tpl->tbHtml( $sFile, 'LIST_HEAD' ).$content.$tpl->tbHtml( $sFile, 'LIST_FOOTER' );
    }
    else
      return $tpl->tbHtml( $sFile, 'NOT_FOUND' );
  } // end function listBasket
}

if( !function_exists( 'saveOrder' ) ){
  /**
  * Zapisywanie zamowienia
  * @return void
  * @param int    $iOrder
  * @param array  $aForm
  */
  function saveOrder( $iOrder, $aForm ){

    $aForm =    changeMassTxt( $aForm, '', Array( 'sComment', 'lenH' ) );

    if( throwStrLen( $aForm['sComment'] ) < 2 )
      $aForm['sComment'] = null;
    elseif( throwStrLen( $aForm['sComment'] ) > 1000 ){					//change 500 -> 1000
      $aForm['sComment'] = substr( $aForm['sComment'], 0, 1000 ).'...';			//change 500 -> 1000
      
      //for japanese
      $aForm['sComment'] = JcodeConvert($aForm['sComment'],0,3);
      //
    }

    if( isset( $aForm['iCourier'] ) ){
      $aCourier = explode( '|', $aForm['iCourier'] );
      $aForm['iCourier'] = $aCourier[0];
    }
    else
      $aForm['iCourier'] = null;

    $aForm['iOrder'] = $iOrder;

    dbSaveOrder( $aForm );

    if( $GLOBALS['config']['mail_informing'] == true ){

      //for japanese
      $sTopic = $GLOBALS['lang']['mail_title'];
      $sTopic = JcodeConvert($sTopic,0,3);
      $sTopic = mb_encode_mimeheader($sTopic, "ISO-2022-JP", "B");
      $sMailContent = $GLOBALS['lang']['mail_txt'];
      $sMailContent = JcodeConvert($sMailContent,0,3);
      $headers = "MIME-Version: 1.0\r\n";
      $headers .= "Content-Language: content=ja\r\n";
      $headers .= "Content-type: text/plain; charset=ISO-2022-JP\r\n";
      $headers .= "From: Simple.Cart";                                      //"From: ".$aForm['sEmail'];
      //

      @mail( EMAIL, $sTopic , $sMailContent , $headers );
    }
  } // end function saveOrder
}

if( !function_exists( 'checkOrderFields' ) ){
  /**
  * Sprawdzanie czy zostaly wypelnione pola zamowienia
  * @return bool
  * @param array  $aForm
  */
  function checkOrderFields( $aForm ){
    if(
      checkLength( $aForm['sFirstName'], 1 )
    //  && checkLength( $aForm['sLastName'], 1 )
    //  && checkLength( $aForm['sStreet'], 1 )
    //  && checkLength( $aForm['sZipCode'], 1 )
    //  && checkLength( $aForm['sCity'], 1 )
    //  && checkTel( $aForm['sTelephone'] )
    //  && checkEmail( $aForm['sEmail'] )    
    //  && checkLength( $aForm['iCourier'], 1 )
    )
      return true;
    else
      return false;
  } // end function checkOrderFields
}

?>