<?php
if( !function_exists( 'dbAddCourier' ) ){
  /**
  * Zapisanie kuriera
  * @return void
  * @param array  $aForm
  */
  function dbAddCourier( $aForm ){
    global $oFF;
    $oFF->setRow( Array( $aForm['sName'], $aForm['iCourier'], $aForm['fPrice'] ) );
    $oFF->addToFile( DIR_DB.DB_COURIERS );
  } // end function dbAddCourier
}

if( !function_exists( 'dbChangeCourier' ) ){
  /**
  * Zmienianie kuriera
  * @return void
  * @param array  $aForm
  */
  function dbChangeCourier( $aForm ){
    global $oFF;
    $oFF->setRow( Array( $aForm['sName'], $aForm['iCourier'], $aForm['fPrice'] ) );
    $oFF->changeInFile( DIR_DB.DB_COURIERS, $aForm['iCourier'], 1 );
  } // end function dbChangeCourier
}

if( !function_exists( 'dbDelCourier' ) ){
  /**
  * Usuwanie kuriera
  * @return void
  * @param int  $iCourier
  */
  function dbDelCourier( $iCourier ){
    $GLOBALS['oFF']->deleteInFile( DIR_DB.DB_COURIERS, $iCourier, 1 );
  } // end function dbDelCourier
}

if( !function_exists( 'dbListCouriers' ) ){
  /**
  * Zwracanie kurierow
  * @return array
  */
  function dbListCouriers( ){
    return $GLOBALS['oFF']->throwFileArray( DIR_DB.DB_COURIERS, 'sort' );
  } // end function dbListCouriers
}

if( !function_exists( 'dbThrowCourier' ) ){
  /**
  * Pobieranie danych kuriera
  * @return array
  * @param int  $iCourier
  */
  function dbThrowCourier( $iCourier ){
    return $GLOBALS['oFF']->throwData( DIR_DB.DB_COURIERS, $iCourier, 1 );
  } // end function dbThrowCourier
}
?>