/* Copyright (c) 2020-2023 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef KEYGEN_H
#define KEYGEN_H

#include "logindialog.h"

#include "../simcore/simapi.h"

#include <QTimer>
#include <QElapsedTimer>

namespace Ui {
class KeyGen;
}

class KeyGen : public LoginDialog
{
  Q_OBJECT

  typedef LoginDialog Parent;

public:
  explicit KeyGen(QWidget * parent = 0);
  ~KeyGen() Q_DECL_OVERRIDE;

  void showNickEdit();

public Q_SLOTS:
  void closeEvent(QCloseEvent * event) Q_DECL_OVERRIDE;
  void changeEvent(QEvent * event) Q_DECL_OVERRIDE;

public slots:
  void on_okButton_clicked();

  void on_actionQuit_triggered() { Parent::on_actionQuit_triggered(); }
  void on_actionConsole_triggered() { Parent::on_actionConsole_triggered(); }
  void on_actionAudioDevices_triggered() { Parent::on_actionAudioDevices_triggered(); }

  void on_actionEnglish_triggered();
  void on_actionFrench_triggered();
  void on_actionGerman_triggered();
  void on_actionUserManual_triggered() { Parent::on_actionUserManual_triggered(); }
  void on_actionAbout_triggered() { Parent::on_actionAbout_triggered(); }

  void onFinished(int);
  void onTimerTimeout();
  void onSignalKeygen(const QString & address, simnumber time2gen);

private:
  Ui::KeyGen * ui;

  qint64 m_time2gen;
  int m_val;

  bool m_autoShow;
  bool m_finished;
  QTimer m_timer;
  QElapsedTimer m_elapsedTime;
};

#endif
