/* Copyright (c) 2020-2023 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef GENERATE_H
#define GENERATE_H

#include "logindialog.h"

namespace Ui {
class Generate;
}

class Generate : public LoginDialog
{
  Q_OBJECT

  typedef LoginDialog Parent;

public:
  explicit Generate(QWidget * parent = 0);
  ~Generate() Q_DECL_OVERRIDE;

  int setBits() const;

  void changeEvent(QEvent * event) Q_DECL_OVERRIDE;

private slots:
  void on_generateButton_clicked();
  void on_loginButton_clicked();

  void on_actionQuit_triggered() { Parent::on_actionQuit_triggered(); }
  void on_actionConsole_triggered() { Parent::on_actionConsole_triggered(); }
  void on_actionAudioDevices_triggered() { Parent::on_actionAudioDevices_triggered(); }

  void on_actionEnglish_triggered();
  void on_actionFrench_triggered();
  void on_actionGerman_triggered();
  void on_actionUserManual_triggered() { Parent::on_actionUserManual_triggered(); }
  void on_actionAbout_triggered() { Parent::on_actionAbout_triggered(); }

private:
  Ui::Generate * ui;
};

#endif
