@echo off

IF NOT EXIST ..\build\build_simphone.bat GOTO nobuild
IF NOT EXIST ..\mingw\bin\mingw32-make.exe GOTO nomingw
IF NOT EXIST ..\qt\bin\qmake.exe GOTO noqt

CD ..
SET PATH=%CD%\qt\bin;%CD%\mingw\bin;%CD%\mingw\opt\bin;%PATH%

echo Copy config files...
xcopy /s /y build\config-win32
IF ERRORLEVEL 1 GOTO noconfig

@echo on
call build_simcore
@echo off
IF ERRORLEVEL 1 GOTO nocore
echo.
echo simcore step done.

CD qsimphone
IF ERRORLEVEL 1 GOTO noqmake
qmake -spec win32-g++ CONFIG+=rlink CONFIG+=portaudio SIMDEFS+=-DSIZEOF_VOID_P=4 -o Makefile qsimphone.pro
IF ERRORLEVEL 1 GOTO noqmake
echo qmake step done.

mingw32-make
IF ERRORLEVEL 1 GOTO nogui
echo.
echo Simphone compiled SUCCESSFULLY.
CD release 2>nul
IF ERRORLEVEL 1 GOTO done
copy /y qsimphone.exe simphone.exe >nul
strip simphone.exe 2>nul
CD ..
:done
CD ..
CD build 2>nul
EXIT /B 0

:nobuild
echo.
echo ERROR: could not find ..\build\build_simphone.bat
echo.
echo Please CD to the build directory where this batch file is and try again.
EXIT /B 1

:nomingw
echo.
echo ERROR: could not find ..\mingw\bin\mingw32-make.exe
echo.
echo Please make sure you have copied AND renamed your mingw directory.
EXIT /B 1

:noqt
echo.
echo ERROR: could not find ..\qt\bin\qmake.exe
echo.
echo Please make sure you have successfully ran build_qt to compile the Qt sources.
EXIT /B 1

:noconfig
echo.
echo ERROR %ERRORLEVEL%: could not copy configuration files.
CD build 2>nul
EXIT /B 1

:nocore
echo.
echo ERROR %ERRORLEVEL%: could not compile simcore.
CD build 2>nul
EXIT /B 1

:noqmake
echo.
echo ERROR %ERRORLEVEL%: could not configure simphone.
CD build 2>nul
CD ..
CD build 2>nul
EXIT /B 1

:nogui
echo.
echo ERROR %ERRORLEVEL%: could not compile simphone.
CD ..
CD build 2>nul
EXIT /B 1
