@echo off

IF NOT EXIST ..\build\build_qt.bat GOTO nobuild
IF NOT EXIST ..\mingw\bin\mingw32-make.exe GOTO nomingw
IF NOT EXIST ..\qtbase\configure.exe GOTO noqt

CD ..
SET PATH=%CD%\mingw\bin;%CD%\mingw\opt\bin;%PATH%
SET PREFIX=%CD%\qt
CD qtbase
IF ERRORLEVEL 1 GOTO noqt
CD ..

xcopy /s /i /q /y qtbase\include\QtCore\5.3.2 qtbase\include\QtCore\5.3.2-sim
xcopy /s /i /q /y qtbase\include\QtDBus\5.3.2 qtbase\include\QtDBus\5.3.2-sim
xcopy /s /i /q /y qtbase\include\QtGui\5.3.2 qtbase\include\QtGui\5.3.2-sim
xcopy /s /i /q /y qtbase\include\QtNetwork\5.3.2 qtbase\include\QtNetwork\5.3.2-sim
xcopy /s /i /q /y qtbase\include\QtOpenGL\5.3.2 qtbase\include\QtOpenGL\5.3.2-sim
xcopy /s /i /q /y qtbase\include\QtPlatformSupport\5.3.2 qtbase\include\QtPlatformSupport\5.3.2-sim
xcopy /s /i /q /y qtbase\include\QtPrintSupport\5.3.2 qtbase\include\QtPrintSupport\5.3.2-sim
xcopy /s /i /q /y qtbase\include\QtSql\5.3.2 qtbase\include\QtSql\5.3.2-sim
xcopy /s /i /q /y qtbase\include\QtTest\5.3.2 qtbase\include\QtTest\5.3.2-sim
xcopy /s /i /q /y qtbase\include\QtWidgets\5.3.2 qtbase\include\QtWidgets\5.3.2-sim
xcopy /s /i /q /y qtbase\include\QtXml\5.3.2 qtbase\include\QtXml\5.3.2-sim

echo.
echo Patching Qt...
python build\patch.py -v patches\501_qt_bugfixes.diff
IF ERRORLEVEL 9009 GOTO nopython
IF ERRORLEVEL 1 GOTO nopatches
IF ERRORLEVEL 0 GOTO patch1
GOTO nopatch
:patch1
python build\patch.py -v patches\530_qt_static.diff
IF ERRORLEVEL 1 GOTO nopatches
IF ERRORLEVEL 0 GOTO patch2
GOTO nopatch
:patch2
python build\patch.py -v patches\531_qt_bugfix.diff
IF ERRORLEVEL 1 GOTO nopatches
IF ERRORLEVEL 0 GOTO patch0
GOTO nopatch
:patch0
python build\patch.py -v patches\532_qt_alert.diff
IF ERRORLEVEL 1 GOTO nopatches
IF ERRORLEVEL 0 GOTO patch3
GOTO nopatch
:patch3

echo Copy qconfig-local.h
COPY /Y build\config-win32\qconfig-local.h qtbase\src\corelib\global
IF ERRORLEVEL 1 GOTO nopatches

CD qtbase
SET QMAKESPEC=win32-g++
.\configure -prefix %PREFIX% -extprefix %PREFIX% -release -no-sse2 -no-sse3 -no-ssse3 -no-sse4.1 -no-sse4.2 -no-avx -no-avx2 -no-direct2d -no-evdev -no-mtdev -no-iwmmxt -no-neon -no-icu -opensource -confirm-license -platform win32-g++ -no-inotify -no-eventfd -no-incredibuild-xge -no-rtti -opengl desktop -no-angle -no-openvg -no-directwrite -no-harfbuzz -no-fontconfig -no-compile-examples -static -no-qml-debug -no-openssl -no-nis -no-cups -no-dbus -no-system-proxies -no-sql-sqlite -nomake examples -nomake tests -qconfig local -nomake tools -no-libjpeg -no-gif -no-accessibility -no-iconv -no-freetype -no-audio-backend -no-wmf-backend -no-style-windowsce -no-style-windowsmobile
IF ERRORLEVEL 1 GOTO noconfig
echo.
echo configure step done.

SET cpus=1
FOR /F "delims=" %%t IN ('python -c "import multiprocessing;print(multiprocessing.cpu_count())"') do SET cpus=%%t
echo.
echo Compiling Qt on %cpus% cores...
echo.
mingw32-make -j %cpus%
IF ERRORLEVEL 1 GOTO nomake
echo.
echo make step done.

mingw32-make install
IF ERRORLEVEL 1 GOTO noinstall
echo.
echo Qt compiled SUCCESSFULLY.
CD ..
CD build 2>nul
EXIT /B 0

:nobuild
echo.
echo ERROR: could not find ..\build\build_qt.bat
echo.
echo Please CD to the build directory where this batch file is and try again.
EXIT /B 1

:nomingw
echo.
echo ERROR: could not find ..\mingw\bin\mingw32-make.exe
echo.
echo Please make sure you have copied AND renamed your mingw directory.
EXIT /B 1

:noqt
echo.
echo ERROR: could not find ..\qtbase\configure.exe
echo.
echo Please make sure you have copied the Qt source code to the parent directory.
echo You need the WINDOWS version of the Qt sources, which contains configure.exe
EXIT /B 1

:nopython
echo.
echo ERROR: could not find ..\mingw\opt\bin\python.exe
echo.
echo Python is required in order to apply the necessary patches to the Qt
echo sources, but it seems that your version of MINGW does not include Python.
echo.
echo You can repair this error by making sure that python.exe is on the PATH
CD build 2>nul
EXIT /B 1

:nopatches
echo.
echo ERROR %ERRORLEVEL%: could not patch the Qt source code.
CD build 2>nul
EXIT /B 1

:nopatch
echo.
echo ERROR %ERRORLEVEL%: could not patch the Qt source code.
echo.
echo The sources under ..\qtbase are not of the correct version of Qt.
echo You may proceed at your own risk.
CD build 2>nul
EXIT /B 1

:noconfig
echo.
echo ERROR %ERRORLEVEL%: could not configure Qt.
CD ..
CD build 2>nul
EXIT /B 1

:nomake
echo.
echo ERROR %ERRORLEVEL%: could not compile Qt.
CD ..
CD build 2>nul
EXIT /B 1

:noinstall
echo.
echo ERROR %ERRORLEVEL%: could not install Qt.
echo.
echo The Qt sources seem to have been compiled, but the Qt libraries
echo and tools could not be copied to the target directory ..\qt. Sorry.
CD ..
CD build 2>nul
EXIT /B 1
