/* Copyright (c) 2020-2022 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef _SERVER_H_
#define _SERVER_H_

#include "simtypes.h"

/* process status packet */
int server_set_status (simcontact contact, simclient client, const simtype version, simunsigned age, simunsigned myage);

/* set type of service to TCP socket */
void server_set_qos (simsocket sock, int tos);

/* check for crypto warnings and send events if necessary */
void server_set_ciphers (simclient client);

/* process version list. consumes versions */
void server_set_versions (simclient client, simcontact contact, simtype versions);

/* add version list to table */
void server_add_versions (simtype table, simcontact contact, int protover,
                          simunsigned nonce, simunsigned myage, simbool oob, simbool server);
/* add ip and port to handshake packet */
void server_add_ip (simtype table, simsocket sock, simbool oob, simbool server);

/* send a pong/QOS packet */
int server_exec_ping (simclient client, const simtype table);

/* read data from peer and respond */
void server_loop_ (simclient client);

/* helper for sim_status_set_ (SIM_STATUS_OFF) */
void server_logoff (int error, int oldstatus);

/* queue (UDP) ping request or reset ping requests if NULL client */
int server_ping (simclient client);

/* send a single (UDP) packet (after adding ping/pong to the arrays) */
int server_send_packet_ (simclient client, simtype arrays, int sequence); /* consumes arrays */

/* process a single received UDP packet */
int server_recv_udp (simclient client, const simtype input, simnumber sequence, unsigned ip, int port);

/* change server port */
int server_set_port (int port);

/* return SIM_PROTO_PORT if listening to it or else return the normal server port or zero if not listening */
int server_get_port (void);

/* check if protocol command is "idle". return false if command contains data sent by user (considered as non-idle) */
simbool server_check_idle (const simtype cmd);

/* start and stop listening to server port */
int server_init_ (simbool init);
int server_uninit_ (simbool init);

/* debug log status and rights */
void server_log_status (const char *module, int level, simsocket sock, simcontact contact,
                        simnumber protover, const char *ipstr, const simtype table, simnumber tick, int oob);
extern const char *server_flag_names[7];

extern simtype server_proto_handshake, server_proto_client, server_proto_audio;
#endif
