#!/bin/sh

checkroot()
{
  if test -n "$BUILD_QT"; then
    echo
    echo "This installer needs to elevate privileges to 'root'."
    echo "The BUILD_QT environment variable you have set would thus be ignored."
    echo "Either unset BUILD_QT or run the installer as 'root' to continue."
    echo
    exit 1
  fi
  if test -n "$BUILD_SIMPHONE"; then
    echo
    echo "This installer needs to elevate privileges to 'root'."
    echo "The BUILD_SIMPHONE environment variable you have set would thus be ignored."
    echo "Either unset BUILD_SIMPHONE or run the installer as 'root' to continue."
    echo
    exit 1
  fi
}

BUILD_INSTALL=$1
PATH=$PATH:/usr/sbin:/sbin:/usr/local/sbin:/usr/local/bin
export PATH BUILD_INSTALL

UNAME=`uname`
if echo $UNAME | grep -i mingw; then
  echo
  echo "This installer is not for Windows. You are completely wrong here, sorry."
  echo
  exit 1
fi
if echo $UNAME | grep -i cygwin; then
  echo
  echo "This installer is not for Cygwin. You are completely wrong here, sorry."
  echo
  exit 1
fi
if test "x$UNAME" = "xDarwin"; then
  echo
  echo "The generic unix installer does not work with Mac OS, as it"
  echo "does not contain all of the source code that is needed by Mac OS."
  echo
  echo "You can either use a precompiled Mac OS application, or compile from"
  echo "the source by downloading the FULL source code and compiling it with Xcode."
  echo
  exit 1
fi

cd installer_simphone/build 2>/dev/null
if test "x$BUILD_INSTALL" != "x--unpack"; then
  date >> ../installer.log 2>/dev/null
fi
./configure
RET=$?
if test "x$BUILD_INSTALL" = "x--unpack"; then
  if test $RET -eq 0; then
    exit $RET
  fi
  date >> ../installer.log 2>/dev/null
fi

if test "x$BUILD_INSTALL" != "x--root"; then
  if test "x$BUILD_INSTALL" != "x--unpack"; then
    if test $RET -eq 101; then
      echo $RET configure >> ../installer.log 2>/dev/null
      echo >> ../installer.log 2>/dev/null
      exit 1
    fi

    if test $RET -eq 102; then
      checkroot
      echo $RET configure >> ../installer.log 2>/dev/null
      echo >> ../installer.log 2>/dev/null
      echo
      echo "The installer couldn't figure out whether you ran it as root or non-root"
      echo "but it does seem to need root privileges. Please re-run it"
      echo "with the --root command-line option, for example like that:"
      echo
      echo '    su root -c "sh ./simphone_installer --root"'
      echo
      exit 2
    fi

    if test $RET -eq 103; then
      checkroot
      echo $RET configure >> ../installer.log 2>/dev/null
      echo
      echo "PLEASE MAKE SURE YOU ARE CONNECTED TO THE INTERNET BEFORE YOU PROCEED ..."
      echo
      echo "This installer needs root privileges and will now try to use 'sudo'."
      echo "If you know how to run the installer as root, stop it now and re-run"
      echo "as root. Otherwise, please type your login password below (will not echo)."
      echo
      sudo sh ./installer.sh --root
      TMP=$?
      echo $TMP sudo >> ../installer.log 2>/dev/null
      if test $TMP -eq 127; then
        TMP=1
      fi

      if test $TMP -eq 1; then
        checkroot
        echo
        echo "PLEASE MAKE SURE YOU ARE CONNECTED TO THE INTERNET BEFORE YOU PROCEED ..."
        echo
        echo "'sudo' didn't work, so the installer will now try to use 'su'."
        echo "If you know how to run the installer as root, stop it now and re-run"
        echo "as root. Otherwise, please type the ROOT password below (will not echo)."
        echo
        su root -c "sh ./installer.sh --root"
        RET=$?
        echo $RET su >> ../installer.log 2>/dev/null
        if test $RET -eq 127; then
          RET=1
        fi

        if test $RET -eq 1; then
          ./installer.sh --root
          RET=$?
          if test $RET -ne 0; then
            if test $RET -ne 100; then
              if test $RET -ne 101; then
                echo
                echo "FATAL: The installer failed to elevate privileges to 'root'."
                echo
                echo "You either failed to enter the correct password or you didn't"
                echo "have privileges to even enter the password. You can retry by"
                echo "re-running the installer, but it's best to first login as 'root'."
                echo
              fi
            fi
          fi
        fi
      fi
    fi
  fi
fi

echo $RET configure $* >> ../installer.log 2>/dev/null
echo >> ../installer.log 2>/dev/null
exit $RET
