/**
    read-only data

    Copyright (c) 2020-2021 The Creators of Simphone

    See the file COPYING.LESSER.txt for copying permission.
**/

#include "config.h"
#include "simtypes.h"

#include "const.h"
#include "error.h"

#include "keytest.h"
#include "countries.h"

#if HAVE_LIBSPEEX
#include "sounds.h"
#endif

#include <string.h>

int sim_const_init (void) {
  const simbyte *t, **p = (const simbyte **) key_country_strings;
  unsigned sum = 0;
#if HAVE_LIBSPEEX
  const simbyte ***sounds = sound_data, **sound, **s;
  while (*sounds)
    if (strcmp (*(const char **) (sound = *sounds++), "keygen"))
      for (s = ++sound; *++s;)
        sum += **s;
#else
  sum = 359129;
#endif
  while (*p)
    while (*p++) {
      for (t = p[-1]; *t;)
        sum += *t++;
    }
  return sum == 474448 ? SIM_OK : SIM_API_BAD_VERSION;
}
