/** Copyright (c) 2020-2021 The Creators of Simphone

    class UserManual (QDialog): display user manual in a window

    See the file COPYING.LESSER.txt for copying permission.
**/

#include "usermanual.h"
#include "ui_usermanual.h"

#include "contacts.h"
#include "qtfix.h"

#include <QFile>

UserManual * UserManual::mc_active = 0;

UserManual::UserManual(QWidget * parent)
  : QDialog(parent), ui(new Ui::UserManual)
{
  ui->setupUi(mc_active = this);
  setAttribute(Qt::WA_DeleteOnClose);
  setWindowFlags(Qt::WindowMaximizeButtonHint | Qt::WindowMinimizeButtonHint |
                 Qt::WindowSystemMenuHint | Qt::WindowCloseButtonHint);
  setFont(qtfix::fixFontSize(font(), "QAbstractItemView"));
  qtfix::fixPointSize(ui->textEdit, font().pointSize());

  QFile file(":/manual");
  if (file.open(QFile::ReadOnly | QFile::Text)) ui->textEdit->setText(file.readAll());

  connect(Contacts::get(), SIGNAL(signalLogout()), this, SLOT(reject()));
}

UserManual::~UserManual()
{
  delete ui;
  mc_active = 0;
}
