/** Copyright (c) 2020-2021 The Creators of Simphone

    class Generate (LoginDialog): choose key size

    See the file COPYING.LESSER.txt for copying permission.
**/

#include "generate.h"
#include "ui_generate.h"

#include "qtfix.h"
#include "simcore.h"

Generate::Generate(QWidget * parent)
  : Parent(parent)
  , ui(new Ui::Generate)
  , m_type(0)
  , m_bits(0)
{
  ui->setupUi(this);
  initLanguage(ui->actionEnglish, ui->actionFrench, ui->actionGerman);
  ui->menubar->adjustSize();
  ui->menubar->resize(width(), ui->menubar->height());
  qtfix::fixPointSize(ui->generateButton, font().pointSize(), 15);
  qtfix::fixPointSize(ui->prefixLabel, font().pointSize());
  qtfix::fixPointSize(ui->suffixLabel, font().pointSize());
  qtfix::fixPointSize(ui->highRadio, font().pointSize());
  qtfix::fixPointSize(ui->highRadioer, font().pointSize());
  qtfix::fixPointSize(ui->highRadioest, font().pointSize());
  qtfix::fixRadioButtonIcon(ui->highRadio, ui->highRadio->font());
  qtfix::fixRadioButtonIcon(ui->highRadioer, ui->highRadioer->font());
  qtfix::fixRadioButtonIcon(ui->highRadioest, ui->highRadioest->font());
  qtfix::fixCheckBoxIcon(ui->seedlessBox, font());

  setWindowFlags(Qt::MSWindowsFixedSizeDialogHint);
  ui->highRadioest->setChecked(false);
  ui->highRadioer->setChecked(false);
  ui->highRadio->setChecked(false);
  switch (abs(SimParam::get("crypto.entropy"))) {
    case 256: ui->highRadioest->setChecked(true); break;
    case 192: ui->highRadioer->setChecked(true); break;
    default: ui->highRadio->setChecked(true);
  }
  ui->seedlessBox->setChecked(SimParam::get("crypto.entropy") < 0);
  sim_audio_hangup_(0);

  ui->label->setPixmap(QPixmap(":/welcome") /*.scaledToWidth(width() - 80, Qt::SmoothTransformation)*/);
  adjustToBiggerSize();
}

Generate::~Generate()
{
  delete ui;
}

void Generate::changeEvent(QEvent * event)
{
  if (event->type() == QEvent::LanguageChange) {
    ui->retranslateUi(this);
    ui->label->setPixmap(QPixmap(":/welcome"));
  }
  Parent::changeEvent(event);
}

void Generate::on_generateButton_clicked()
{
  if (ui->highRadio->isChecked()) {
    m_bits = 128;
    m_type = SIM_KEY_BP512R1_RSA4K;
    accept();
  } else if (ui->highRadioer->isChecked()) {
    m_bits = 192;
    m_type = SIM_KEY_BP512R1_RSA8K;
    accept();
  } else if (ui->highRadioest->isChecked()) {
    m_bits = 256;
    m_type = SIM_KEY_BP512R1_RSA16K;
    accept();
  } else {
    m_type = m_bits = 0;
  }

  if (ui->seedlessBox->isChecked()) m_bits = -m_bits;
}

void Generate::on_loginButton_clicked()
{
  done(2);
}

void Generate::on_actionEnglish_triggered()
{
  Parent::on_actionEnglish_triggered(ui->actionEnglish, ui->actionFrench, ui->actionGerman);
}

void Generate::on_actionFrench_triggered()
{
  Parent::on_actionFrench_triggered(ui->actionEnglish, ui->actionFrench, ui->actionGerman);
}

void Generate::on_actionGerman_triggered()
{
  Parent::on_actionGerman_triggered(ui->actionEnglish, ui->actionFrench, ui->actionGerman);
}
