<?php

require_once('Smarty.class.php');
require_once('simg-functions.php');

/**
 * リスナ比較関数
 */
function _listenerCompare($l1, $l2) {
	return ($l1->getPriority() > $l2->getPriority())? 1: -1;
}

/**
 * コントローラ基底クラス
 * @author System Concept
 *
 */
abstract class SimgController {

	/**
	 * Path管理
	 */
	protected $app_path;

	/**
	 * 構築
	 * @param $ap Path管理
	 */
	public function __construct($ap) {
		$this->initialize($ap);
	}
	/**
	 * 初期化
	 * @param $ap Path管理
	 */
	private function initialize($ap) {
		$this->app_path = $ap;
		//simg_config_load($this->getEtcConfigPath());
		simg_config_load(simg_parse_ini_file_pathes($ap->getPathes('getConfigPath'), SIMG_FN_CONFIG_ETC));
		//simg_make_definemap($this->getEventConfigPath(), array('event', 'parameter'), array());
		simg_make_definemap(simg_parse_ini_file_pathes($ap->getPathes('getConfigPath'), SIMG_FN_CONFIG_EVENT, true), array('event', 'parameter'), array());
	}
	/**
	 * ディレクトリ配下のPHPファイルからインスタンスを生成する
	 * @param $dir ディレクトリ
	 * @param $baseclass 基底クラス
	 * @param $args コンストラクタ引数
	 * @param $instances インスタンス配列
	 * @param $cmap クラス重複チェックMAP
	 * @return インスタンス配列
	 */
	//protected function createInstanceOnDirectory($dir, $baseclass, $args, $instances, $cmap) {
	//	if(is_null($instances)) {
	//		$instances = array();
	//	}
	//	if(is_null($cmap)) {
	//		$cmap = array();
	//	}
	//	$dir_handle = opendir($dir);
	//	while($file_name = readdir($dir_handle)) {
	//		$ext = pathinfo($file_name, PATHINFO_EXTENSION);
	//		if($ext == 'php') {
	//			$cn = pathinfo($file_name, PATHINFO_FILENAME);
	//			if(!isset($cmap[$cn])) {
	//				$cmap[$cn] = "";
	//				$ins = simg_create_instance($dir, $cn, $args);
	//				if(!is_null($ins) && $ins instanceof $baseclass) {
	//					$instances[] = $ins;
	//				}
	//			}
	//		}
	//	}
	//	return $instances;
	//}
	/**
	 * ディレクトリ配下のPHPファイルからインスタンスを生成する
	 * @param $pathes パス配列
	 * @param $baseclass 基底クラス
	 * @param $args コンストラクタ引数
	 * @return インスタンス配列
	 */
	//protected function createInstanceOnDirectoryByPathes($pathes, $baseclass, $args) {
	//	$instances = array();
	//	$cmap = array();
	//	foreach($pathes as $path) {
	//		$instances = $this->createInstanceOnDirectory($path, $baseclass, $args, $instances, $cmap);
	//	}
	//	return $instances;
	//}
	/**
	 * event-configファイルパス取得
	 * @return ファイルパス
	 */
	//protected function getEventConfigPath() {
	//	return simg_combine_path(SIMG_PATH_CONFIG, SIMG_FN_CONFIG_EVENT);
	//}
	/**
	 * etc-configファイルパス取得
	 * @return ファイルパス
	 */
	//protected function getEtcConfigPath() {
	//	return simg_combine_path(SIMG_PATH_CONFIG, SIMG_FN_CONFIG_ETC);
	//}
	/**
	 * デフォルトイベント取得
	 * @return イベント
	 */
	abstract public function getDefaultEvent();
	/**
	 * ディレクトリ配下のPHPファイルからインスタンスを生成しソート後返却する
	 * @param $pathes パス配列
	 * @param $baseclass 基底クラス
	 * @param $args コンストラクタ引数
	 * @return インスタンス配列
	 */
	protected function createInstanceOnDirectoryBySort($pathes, $baseclass) {
		//SimgLog::getInstance()->put(PEAR_LOG_DEBUG, "createInstanceOnDirectoryBySort : pathes [%s]", print_r($pathes, true));
		//SimgLog::getInstance()->put(PEAR_LOG_DEBUG, "> : pathes [%s]", $baseclass);
		$instances = array();
		//foreach($this->createInstanceOnDirectoryByPathes($pathes, $baseclass, $args) as $instance) {
		//	$instances[] = $instance;
		//}
		foreach(simg_create_instance_on_directory_by_pathes($pathes, $baseclass, array()) as $instance) {
			$instances[] = $instance;
		}
		//simg_create_instance_on_directory_by_pathes($pathes, $baseclass, $args)
		usort($instances, "_listenerCompare");
		return $instances;
	}
	/**
	 * コントローラ実行
	 * @param $output 出力
	 * @param $parameter パラメータ
	 * @param $db DB
	 */
	public function run($output, $parameter, $db) {
		try {
			$ap = $this->app_path;
			$event = simg_get_array_value($_GET, SIMG_PARAM_EVENT, $this->getDefaultEvent());
			$cancel = false;
			foreach($this->createInstanceOnDirectoryBySort($ap->getPathes('getPorterPath'), 'SimgPorter') as $porter) {
				if(!$porter->check($event, $output, $parameter, $db)) {
					$cancel = true;
					break;
				}
			}
			if(!$cancel) {
				foreach($this->createInstanceOnDirectoryBySort($ap->getPathes('getActionPath'), 'SimgAction') as $action) {
					$action->execute($event, $output, $parameter, $db);
				}
				foreach($this->createInstanceOnDirectoryBySort($ap->getPathes('getPagerPath'), 'SimgPager') as $pager) {
					$pager->paging($event, $output, $parameter, $db);
				}
			}
			$output->preRendering($event, $parameter, $db);
			foreach($this->createInstanceOnDirectoryBySort($ap->getPathes('getRenderPath'), 'SimgRender') as $render) {
				$render->rendering($event, $output, $parameter, $db);
			}
		} catch (Exception $e) {
			$output->error($e);
		}
		if(!$output->display()) {
			header('HTTP/1.0 404 Not Found');
			print('<html><head><title>simg</title></head><body><p>Page not Found !</p></body></html>');
		}
	}
}

?>
