<?php

require_once('SimgDb.php');

/**
 * ユーザーDB
 * @author System Concept
 *
*/
class Db extends SimgDb {

	/**
	 * 全てのカテゴリを取得する
	 * @return カテゴリ配列
	 */
	public function getCategoryAll() {
		return $this->select(
			sprintf("select * from %s", TB_CATEGORY)
		);
	}
	/**
	 * レコードを取得する
	 * @param $tb テーブル名
	 * @param $id ID
	 * @param $att 属性
	 * @return レコード
	 */
	public function getRecord($tb, $id, $att="*") {
		$rec = $this->select(
			sprintf("select %s from %s where %s=%d", $att, $tb, AT_ID, $id)
		);
		return (count($rec) > 0)? $rec[0]: null;
	}
	/**
	 * ユーザ検索
	 * @param $name ユーザ名
	 * @return ユーザ情報
	 */
	public function findUser($name) {
		$rec = $this->select(
				sprintf("select * from %s where %s='%s'", TB_USER, AT_NAME, $name)
		);
		return (count($rec) > 0)? $rec[0]: null;
	}
	/**
	 * 指定キーの記事を取得する
	 * @param $key キー
	 * @return 記事配列
	 */
	public function getArticleByKey($key) {
		return $this->select(
			sprintf("select * from %s where %s='%s'", TB_ARTICLE, AT_KEY, $key)
		);
	}
	/**
	 * 指定キーの記事を指定開始行より取得する
	 * @param $key キー
	 * @param $offset 開始位置
	 * @param $limit 行数
	 * @return 記事配列
	 */
	public function getArticleByKeyForPaging($key, $offset, $limit) {
		//SimgLog::getInstance()->put(PEAR_LOG_DEBUG, "getArticleByKeyForPaging >> [%s], %d, %d", $key, $offset, $limit);
		return $this->select(
			sprintf("select * from %s where %s='%s' limit %d offset %d", TB_ARTICLE, AT_KEY, $key, $limit, $offset)
		);
	}
	/**
	 * 指定キーの記事が指定開始行以降に存在するか
	 * @param $key キー
	 * @param $offset 開始位置
	 * @return true=存在する
	 */
	public function isExistArticleByKeyForOffset($key, $offset) {
		return 	$this->count(
					sprintf("select %s from %s where %s='%s' limit %d offset %d", AT_ID, TB_ARTICLE, AT_KEY, $key, 1, $offset)
				) > 0;
	}
	/**
	 * SELECT文を実行する
	 * @param $sql SQL文
	 * @return 結果
	 */
	public function select($sql) {
		//SimgLog::getInstance()->put(PEAR_LOG_DEBUG, "DB select >> [%s]", $sql);
		$st = $this->db->query($sql);
		return $st->fetchAll(PDO::FETCH_ASSOC);
	}
	/**
	 * 行数カウント
	 * @param $sql SQL文
	 * @return 行数
	 */
	public function count($sql) {
		$st = $this->db->query($sql);
		return count($st->fetchAll(PDO::FETCH_ASSOC));
	}
	/**
	 * 値を設定する
	 * @param $tb テーブル名
	 * @param $att 属性
	 * @param $v 値
	 * @param $id ID
	 */
	public function setValue($tb, $att, $v, $id) {
		$stmt = $this->db->prepare(sprintf("update %s set %s='%s' where %s=%d", $tb, $att, $v, AT_ID, $id));
		$stmt->execute();
	}
	/**
	 * 投票する
	 * @param $id 記事ID
	 */
	public function voteArticle($id) {
		$rec = $this->getRecord(TB_ARTICLE, $id, AT_VOTE);
		if(!is_null($rec)) {
			$this->setValue(TB_ARTICLE, AT_VOTE, $rec[AT_VOTE] + 1, $id);
		}
	}
}

?>
