<?php

require_once('SimgRender.php');

/**
 * ログインレンダー
 * @author System Concept
 *
*/
class LoginRender extends SimgRender {

	/**
	 * レンダリング
	 * @param $event イベント
	 * @param $output 出力
	 * @param $parameter パラメータ
	 * @param $db DB
	 */
	public function rendering($event, $output, $parameter, $db) {
		if($output->hasPartial(PARTIAL_LOGIN)) {
			$output->assign(SMARTY_ACTION_URL, simg_current_url());
			if($output->getError() == ERR_AUTHENTICATION_FAULT) {
				$output->assign(SMARTY_ERROR_MESSAGE, LOGIN_ERROR_MESSAGE);
			}
		}
	}
}

?>
