<?php

require_once('SimgRender.php');

/**
 * 結果レンダー
 * @author System Concept
 *
*/
class ResultRender extends SimgRender {

	/**
	 * レンダリング
	 * @param $event イベント
	 * @param $output 出力
	 * @param $parameter パラメータ
	 * @param $db DB
	 */
	public function rendering($event, $output, $parameter, $db) {
		if($output->hasPartial(PARTIAL_RESULT)) {
			$id = simg_get_value($parameter->get(P_ITEM), -1);
			$rec = $db->getRecord(TB_ARTICLE, $id, AT_VOTE);
			if(!is_null($rec)) {
				$output->assign(SMARTY_JS_RESULT, JS_OK);
				$output->assign(SMARTY_JS_VALUE, simg_get_value($rec[AT_VOTE], -1));
			} else {
				$output->assign(SMARTY_JS_RESULT, JS_NG);
				$output->assign(SMARTY_JS_VALUE, -1);
			}
		}
	}
}

?>
