<?php

require_once('simg-functions.php');

/**
 * Simg入口クラス
 * @author System Concept
 *
 */
class SimgEntry {

	/**
	 * 構築
	 * @param $app_root Applicationルートパス
	 * @param $simg_root Simgルートパス
	 */
	public function __construct($app_root, $simg_root) {
		$this->initialize($app_root, $simg_root);
	}
	/**
	 * 初期化処理
	 * @param $app_root Applicationルートパス
	 * @param $simg_root Simgルートパス
	 */
	private function initialize($app_root, $simg_root) {
		// Simg定数初期化
		simg_config_load($simg_root . '/simg.ini');
		// 予約定数初期化
		define('SIMG_ROOT', $simg_root);
		define('SIMG_PATH_ROOT', $app_root);
		define('SIMG_PATH_APPLICATION', simg_combine_path(SIMG_PATH_ROOT, SIMG_DIRECTORY_APPLICATION));
		define('SIMG_PATH_CONFIG', simg_combine_path(SIMG_PATH_APPLICATION, SIMG_DIRECTORY_CONFIG));
		define('SIMG_PATH_CONTROLLER', simg_combine_path(SIMG_PATH_APPLICATION, SIMG_DIRECTORY_CONTROLLER));
		define('SIMG_PATH_PORTER', simg_combine_path(SIMG_PATH_CONTROLLER, SIMG_DIRECTORY_PORTER));
		define('SIMG_PATH_ACTION', simg_combine_path(SIMG_PATH_CONTROLLER, SIMG_DIRECTORY_ACTION));
		define('SIMG_PATH_PAGER', simg_combine_path(SIMG_PATH_CONTROLLER, SIMG_DIRECTORY_PAGER));
		define('SIMG_PATH_RENDER', simg_combine_path(SIMG_PATH_CONTROLLER, SIMG_DIRECTORY_RENDER));
		define('SIMG_PATH_MODEL', simg_combine_path(SIMG_PATH_APPLICATION, SIMG_DIRECTORY_MODEL));
		define('SIMG_PATH_VIEW', simg_combine_path(SIMG_PATH_APPLICATION, SIMG_DIRECTORY_VIEW));
		define('SIMG_PATH_TEMPLATE', simg_combine_path(SIMG_PATH_VIEW, SIMG_DIRECTORY_TEMPLATE));
		define('SIMG_PATH_TEMPLATE_CACHE', simg_combine_path(SIMG_PATH_VIEW, SIMG_DIRECTORY_TEMPLATE_CACHE));
		define('SIMG_PATH_TEMPLATE_COMPILE', simg_combine_path(SIMG_PATH_VIEW, SIMG_DIRECTORY_TEMPLATE_COMPILE));
		define('SIMG_PATH_RESOURCE', simg_combine_path(SIMG_PATH_VIEW, SIMG_DIRECTORY_RESOURCE));
		define('SIMG_PATH_PLUGIN', simg_combine_path(SIMG_PATH_VIEW, SIMG_DIRECTORY_PLUGIN));
		define('SIMG_RESOURCE_EXT', simg_get_array_value($_REQUEST, SIMG_PARAM_LANGUAGE, 'ini'));
	}
	/**
	 * ディスパッチ
	 */
	public function dispatch() {
		$controller = simg_create_instance(SIMG_PATH_CONTROLLER, SIMG_CLASS_USER_CONTROLLER);
		$output = simg_create_instance(SIMG_PATH_MODEL, SIMG_CLASS_USER_OUTPUT);
		$parameter = simg_create_instance(SIMG_PATH_MODEL, SIMG_CLASS_USER_PARAMETER);
		$db = simg_create_instance(SIMG_PATH_MODEL, SIMG_CLASS_USER_DB);
		$controller->run($output, $parameter, $db);
	}
}

?>
