<?php

require_once('Smarty.class.php');
require_once('simg-functions.php');

/**
 * リスナ比較関数
 */
function _listenerCompare($l1, $l2) {
	return ($l1->getPriority() > $l2->getPriority())? 1: -1;
}

/**
 * コントローラ基底クラス
 * @author System Concept
 *
 */
abstract class SimgController {

	/**
	 * 構築
	 */
	public function __construct() {
		$this->initialize();
	}
	/**
	 * 初期化
	 */
	private function initialize() {
		simg_config_load($this->getEtcConfigPath());
		simg_make_definemap($this->getEventConfigPath(), array('event', 'parameter'), array());
	}
	/**
	 * ディレクトリ配下のPHPファイルからインスタンスを生成する
	 * @param $dir ディレクトリ
	 * @param $baseclass 基底クラス
	 * @return インスタンス配列
	 */
	protected function createInstanceOnDirectory($dir, $baseclass) {
		$instances = array();
		$dir_handle = opendir($dir);
		while($file_name = readdir($dir_handle)) {
			$ext = pathinfo($file_name, PATHINFO_EXTENSION);
			if($ext == 'php') {
				$ins = simg_create_instance($dir, pathinfo($file_name, PATHINFO_FILENAME));
				if(!is_null($ins) && $ins instanceof $baseclass) {
					$instances[] = $ins;
				}
			}
		}
		return $instances;
	}
	/**
	 * event-configファイルパス取得
	 * @return ファイルパス
	 */
	protected function getEventConfigPath() {
		return simg_combine_path(SIMG_PATH_CONFIG, SIMG_FN_CONFIG_EVENT);
	}
	/**
	 * etc-configファイルパス取得
	 * @return ファイルパス
	 */
	protected function getEtcConfigPath() {
		return simg_combine_path(SIMG_PATH_CONFIG, SIMG_FN_CONFIG_ETC);
	}
	/**
	 * デフォルトイベント取得
	 * @return イベント
	 */
	abstract public function getDefaultEvent();
	/**
	 * ディレクトリ配下のPHPファイルからインスタンスを生成しソート後返却する
	 * @param $dir ディレクトリ
	 * @param $baseclass 基底クラス
	 * @return インスタンス配列
	 */
	protected function createInstanceOnDirectoryBySort($dir, $baseclass) {
		$instances = array();
		foreach($this->createInstanceOnDirectory($dir, $baseclass) as $instance) {
			$instances[] = $instance;
		}
		usort($instances, "_listenerCompare");
		return $instances;
	}
	/**
	 * コントローラ実行
	 * @param $output 出力
	 * @param $parameter パラメータ
	 * @param $db DB
	 */
	public function run($output, $parameter, $db) {
		try {
			$event = simg_get_array_value($_GET, SIMG_PARAM_EVENT, $this->getDefaultEvent());
			$cancel = false;
			foreach($this->createInstanceOnDirectoryBySort(SIMG_PATH_PORTER, 'SimgPorter') as $porter) {
				if(!$porter->check($event, $output, $parameter, $db)) {
					$cancel = true;
					break;
				}
			}
			if(!$cancel) {
				foreach($this->createInstanceOnDirectoryBySort(SIMG_PATH_ACTION, 'SimgAction') as $action) {
					$action->execute($event, $output, $parameter, $db);
				}
				foreach($this->createInstanceOnDirectoryBySort(SIMG_PATH_PAGER, 'SimgPager') as $pager) {
					$pager->paging($event, $output, $parameter, $db);
				}
			}
			foreach($this->createInstanceOnDirectoryBySort(SIMG_PATH_RENDER, 'SimgRender') as $render) {
				$render->rendering($event, $output, $parameter, $db);
			}
		} catch (Exception $e) {
			$output->error($e);
		}
		if(!$output->display()) {
			header('HTTP/1.0 404 Not Found');
			print('<html><head><title>simg</title></head><body><p>Page not Found !</p></body></html>');
		}
	}
}

?>
