require 'test/unit/testcase'
require 'amrita/template'
require 'amrita/testsupport'

class TestManager < Test::Unit::TestCase
  include Amrita
  def setup
    TemplateManager.instance.clear_mem_cache
  end

  def test_template_cache1
    return if RUBY_VERSION > "1.8" # marshal is not supported now with 1.8
    require "ftools"
    tempfile = "/tmp/amritatest#{$$}"
    cachedir = "/tmp/amritacache#{$$}"
    File::makedirs(cachedir)
    TemplateManager::set_cache_dir(cachedir)

    File.open(tempfile, "w") { |f| f.print <<-END }
    <p id="a">sample_text</p>
    END


    t = TemplateManager[tempfile]
    # t.use_compiler = true
    assert_equal(true, t.need_update?)
    result = ""
    t.expand(result, { :a=>"aaa" })
    sleep 1.1 # for test of need_update?
    assert_equal("    <p>aaa</p>\n", result)

    t = TemplateManager[tempfile]
    result = ""
    t.expand(result, { :a=>"aaa" })
    sleep 1.1 # for test of need_update?
    assert_equal("    <p>aaa</p>\n", result)


    File.open(tempfile, "w") { |f| f.print <<-END }
    <p id="a">sample_text</p>xxx
    END
    result = ""
    assert_equal(true, t.need_update?)
    t.expand(result, { :a=>"aaa" })
    assert_equal("    <p>aaa</p>xxx\n", result)
    assert_equal(false, t.need_update?)
  ensure
    begin
      #File.open(tempfile) { |f| puts f.read }
      File::unlink(tempfile) if tempfile
    rescue Errno::ENOENT
    end
    system "rm -r #{cachedir}" if cachedir.to_s != ""
  end
end


#--- main program ----
if __FILE__ == $0
  require 'test/unit/ui/console/testrunner'

  if ARGV.size == 0
    Test::Unit::UI::Console::TestRunner.run(TestManager, Test::Unit::UI::Console::TestRunner::VERBOSE)
    require 'amrita/accel'
    Test::Unit::UI::Console::TestRunner.run(TestManager)
  else
    require 'amrita/accel'
    ARGV.each do |method|
      Test::Unit::UI::Console::TestRunner.run(TestManager.new(method))
    end
  end
end

