require 'amrita/amulet'
require 'amrita/accel'
include Amrita

tmpl = TemplateText.new <<END
<html>
<body>
  <table> 
    <tr><th>name</th><th>author</th><th>webpage</tr>
    <tr id=row_data>
      <td id=lang><td id=author><td id=homepage>
    </tr>
    <tr id=row_data2>
       <td><font id=lang color=red></font>
       <td><em id=author></em>
       <td id=homepage>
    </tr>
  </table>
</body>
END

class RowData < AmuletStruct.new(:lang, :author, :url, :title)
  def homepage
    e(:a, :href=>url) { title.gsub('_', ' ') }
  end
end

tmpl.define_amulet(:row_data=>RowData, :row_data2=>RowData)

source_data = [
  %w(Perl Wall http://www.perl.com/ Perl.com),
  %w(Ruby matz http://www.ruby-lang.org Ruby_Home_Page),
  %w(Python Rossum http://www.python.org/ Python_Language_WepSite),
]

data = source_data.collect do |*a|
  id = a[0] != 'Ruby' ? :row_data : :row_data2
  tmpl[id][*a]
end

#tmpl.debug_compiler = true
tmpl.expand(STDOUT, :row_data=>data)
