require 'runit/testcase'
require 'amrita/parser'
require 'amrita/testsupport'

load 'tasks.rb'

ENV["FNAME"] = "minimam.dat"

class TestBenchMark < RUNIT::TestCase
  include Amrita

  def test_all
    puts "start"
    ENV["CNT"] = "1"
    answer = IO::popen("#{$tasks[0][1]}").read
    $tasks[1..-1].each do |description, cmd|
      puts "checking #{description} \"#{cmd}\""
      ret = IO::popen("#{cmd}").read
      assert_equal_node(answer, ret)
    end
  end

  def test_all_5
    puts "start"
    ENV["CNT"] = "5"
    answer = IO::popen("#{$tasks[0][1]}").read
    $tasks[1..-1].each do |description, cmd|
      puts "checking #{description} \"#{cmd}\""
      ret = IO::popen("#{cmd}").read
      assert_equal_node(answer, ret)
    end
  end

end

def compile_amcc
  t1 = File::stat("amrita_template.html")
  t2 = File::stat("amrita_template_pragma.html")
  so = File::stat("ext/amccout.so")
  #p t1.mtime, t2.mtime, so.mtime

  if t1.mtime > so.mtime or t2.mtime > so.mtime
    puts 'ruby -I../../lib amcc.rb compile'
    system 'ruby -I../../lib amcc.rb compile'
  end
end

#--- main program ----
if __FILE__ == $0
  require 'runit/cui/testrunner'
  compile_amcc

  if ARGV.size == 0
    RUNIT::CUI::TestRunner.run(TestBenchMark.suite)
  else
    ARGV.each do |method|
      RUNIT::CUI::TestRunner.run(TestBenchMark.new(method))
    end
  end
end

