require "amrita/vm"
require "amrita/parser"
require "amrita/accel"
include Amrita

load 'make_data.rb'

$data[:table].each do |item|
  item[:webpage] = a(:href=>item[:url]) { item[:webpage_name] }
end

TEMPLATE = <<END
<html>
<head>
<title id="title"></title>
</head>
<body>
<h1 id="title"></h1>
<table border="1">
  <tr><th>name</th><th>author</th><th>webpage</tr>
  <tr id="table">
    <td id="name"></td>
    <td id="author"></td>
    <td><a id="webpage"></a></td>
  </tr>
</table>
</body>
</html>
END

TEMPLATE_WITH_PRAGMA = <<END
<html>
<head>
<!-- amrita_pragma: ScalarData -->
<title id="title"></title>
</head>
<body>
<!-- amrita_pragma: ScalarData -->
<h1 id="title"></h1>
<table border="1">
  <tr><th>name</th><th>author</th><th>webpage</tr>
  <!-- amrita_pragma: EnumerableData[HashData] -->
  <tr id="table">
    <!-- amrita_pragma: ScalarData -->
    <td id="name"></td>
    <!-- amrita_pragma: ScalarData -->
    <td id="author"></td>
    <!-- amrita_pragma: AttrData -->
    <td><a id="webpage"></a></td>
  </tr>
</table>
</body>
</html>
END

cnt = ARGV.shift.to_i

vm = VirtualMachine.new(STDOUT)
node = HtmlParser::parse_text TEMPLATE
#node = HtmlParser::parse_text TEMPLATE_WITH_PRAGMA
#node = HtmlParser::parse_text  "<!-- amrita_pragma: ScalarData --><h1 id=title></h1>", 
compiler = Compiler.new
bytecode = node.convert_to_bytecode(compiler)

case o = ARGV.shift
when "direct",nil
  vm.load_bytecode(bytecode)
  cnt.times  do
    vm.register = $data
    vm.go
  end
when "jit"
  vm.use_compiler = true
  #vm.optimize_bytecode = true
  vm.load_bytecode(bytecode)
  cnt.times  do
    vm.register = $data
    vm.go
  end
when "debug"
  vm.debug = true
  vm.optimize_bytecode = true
  vm.load_bytecode(bytecode)
  #vm.dump_bytecode 
  cnt.times  do
    vm.register = $data
    vm.go
  end
when "dump"
  vm.debug = true
  vm.optimize_bytecode = true
  vm.use_compiler = true
  vm.load_bytecode(bytecode)

  vm.dump_bytecode 
else
  raise "unknown option #{o}"
end

