require "amrita/template"
include Amrita

load 'make_data.rb'

$data[:table].each do |item|
  if item[:webpage_name] and item[:webpage_name] != ""
    if item[:url] and item[:url] != ""
      item[:webpage] = e(:a, :href=>item[:url]) { item[:webpage_name] }
    else
      item[:webpage] = item[:webpage_name] 
    end
  else
    item[:webpage] = nil
  end
end

cache_dir = "/tmp/amrita_bench"
Dir::mkdir(cache_dir) unless FileTest::directory? cache_dir
TemplateManager::set_cache_dir(cache_dir)
template_file = ARGV.shift || 'amrita_template.html'
tmpl = TemplateManager[template_file]
tmpl.use_compiler=true

$cnt.times  do
  tmpl.expand(STDOUT, $data)  # without compiling
end

