#----------------------------------------------------------------------------
#   archive.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2004 January Nowake(野分) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア
#  財団によって発行された GNU一般公衆利用許諾契約書(バージョン2)の定める条件
#  の下で再頒布または改変することができます。
#  このプログラムは有用であることを願って頒布されますが、
#    *全くの無保証*
#  です。商業可能性の保証や特定の目的への適合性は、言外に示されたものも含め
#  全く存在しません。詳しくはGNU 一般公衆利用許諾契約書をご覧ください。
#  あなたはこのプログラムと共に、GNU 一般公衆利用許諾契約書の複製物を一部
#  受け取ったはずです。もし受け取っていなければ、フリーソフトウェア財団まで
#  請求してください。
#  (宛先は the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------

module Formatter
  class Archive
    @@max_size = 1000000
    attr_reader( :source_on_show )
    def initialize( variables )
      @variables =  variables
      @source_on_show = '^#Archive$'
    end
    def self.max_size=( value )
      @@max_size = value
    end
    def on_show( match_text, target_range, node )
      fn = @variables.formatter_template_root + 'archive/form.html'
      template = Amrita::TemplateText.new(
          File.open( fn, "r+b" ) do | f | f.read.untaint end )
      items = []
      node.container_items.each do | i |
        uri_item = 
            "#{@variables.cgi_uri}\?" +
            "#{Command.base_name}=#{Command::Show.base_name};" +
            "#{Node::Target.base_name}=#{node.escaped_name}!#{i}"
        items << { :uri_item => uri_item, :name => i }
     end
     data = {
        :cgi_uri => @variables.cgi_uri,
        :command => Command.base_name,
        :command_name => Command::Execute.base_name,
        :formatter => Formatter.base_name,
        :formatter_name => Formatter::Archive.base_name,
        :node => Node::Target.base_name,
        :node_name => node.escaped_name,
        :items => items,
      }
      template.expand( "", data )
    end
    def on_call( node )
      return @variables.cgi["file"].size.to_s if
          @@max_size < @variables.cgi["file"].size
      file_name = @variables.cgi["file"].original_filename
      data = @variables.cgi["file"].read
      container = Node::Accessor.new( node.name + '!' + file_name, @variables )
      container.content = data
      container.save
      @variables.http_header_set['Location'] =
          "#{@variables.cgi_uri}?" +
          "#{Command.base_name}=#{Command::Show.base_name};" +
          "#{Node::Target.base_name}=#{node.escaped_name}"
    end
  end
end

