#----------------------------------------------------------------------------
#   index.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2003 August Nowake(野分) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア
#  財団によって発行された GNU一般公衆利用許諾契約書(バージョン2)の定める条件
#  の下で再頒布または改変することができます。
#  このプログラムは有用であることを願って頒布されますが、
#    *全くの無保証*
#  です。商業可能性の保証や特定の目的への適合性は、言外に示されたものも含め
#  全く存在しません。詳しくはGNU 一般公衆利用許諾契約書をご覧ください。
#  あなたはこのプログラムと共に、GNU 一般公衆利用許諾契約書の複製物を一部
#  受け取ったはずです。もし受け取っていなければ、フリーソフトウェア財団まで
#  請求してください。
#  (宛先は the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------

module Formatter end

module FormatterTool
  def self.create_processor( set_name, set_array, variables )
    path = "#{File.dirname( __FILE__ )}/#{set_name}/"
    f = SikiTool::create_factory( Formatter, path, set_array )
    class << f
      attr_accessor( :on_show_impl, :on_save_impl )
      def on_show( target_text, target_range, node )
        return @on_show_impl.execute( :on_show,target_text,target_range,node )
      end
      def on_save( target_text, target_range, node )
        return @on_save_impl.execute( :on_save,target_text,target_range,node )
      end
    end
    f.on_show_impl = FormatterImpl.new( :source_on_show, f, variables ) 
    f.on_save_impl = FormatterImpl.new( :source_on_save, f, variables )
    f.freeze
  end

  class FormatterImpl
    attr_accessor( :regexp, :object, :source )
    def initialize( method_symbol, class_array, variables )
      @variables = variables
      @source = "(?!)"
      @object = [ nil ]
      class_array.each do | key, value |
        if value == self.class then next end
        obj = value.new( variables )
        if obj.class.method_defined?( method_symbol )
          @object << obj
          @source = "(#{@source}|(#{obj.method( method_symbol ).call}))"
        end
      end
      @object.reverse!
      @regexp = Regexp.new( @source, Regexp::MULTILINE )
    end
    def execute( method_symbol, target_text, target_range, node )
      return target_text if @source == ''
      target_text.gsub( @regexp ) do | m |
        index = 0
        @object.each_index do | i | index = i - 1 if $~[i] end
        r = FormatterTool.get_substring_range(target_range,$~.begin(0),$~[0])
        @object[index].method( method_symbol ).call( $~[0], r, node )
      end
    end
  end

  def self.get_substring_range( range, pos, sub_string )
    begin_offset = range.begin + pos
    end_offset = begin_offset + sub_string.size
    begin_offset...end_offset
  end
end

