#----------------------------------------------------------------------------
#   main.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2003 August Nowake(野分) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア
#  財団によって発行された GNU一般公衆利用許諾契約書(バージョン2)の定める条件
#  の下で再頒布または改変することができます。
#  このプログラムは有用であることを願って頒布されますが、
#    *全くの無保証*
#  です。商業可能性の保証や特定の目的への適合性は、言外に示されたものも含め
#  全く存在しません。詳しくはGNU 一般公衆利用許諾契約書をご覧ください。
#  あなたはこのプログラムと共に、GNU 一般公衆利用許諾契約書の複製物を一部
#  受け取ったはずです。もし受け取っていなければ、フリーソフトウェア財団まで
#  請求してください。
#  (宛先は the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------


$stdout.binmode
node_name = CGI.unescape($Variables.cgi_value( Node::Target.base_name ))
node = Node::Reader.new( node_name, $Variables )
command = $Variables.command[$Variables.command_name].new( $Variables )
fn = $Variables.command_template_root+'main.html'
template = Amrita::TemplateText.new(
    File.open( fn, "r+b" ) do | f | f.read.untaint end )
information_node = Node::Reader.new( $Variables.information_name, $Variables )
title_link = ""; t = ""
node.name.split('/').each do | i |
  t = (t == "") ? i : t + '/' + i
  l = $Variables.command_uri( Command::Show.base_name, CGI.escape( t ) )
  title_link << "<a href=\"#{l}\">#{i}</a>" + '/'
end
title_link.chop!
$Variables.content_set = {
  :stylesheet => $Variables.theme_uri,
  :title => node.name,
  :title_link => Amrita::SanitizedString[title_link],
  :command => Command.base_name,
  :edit => Command::Edit.base_name,
  :node => Node::Target.base_name,
  :information_content => Amrita::SanitizedString[information_node.html_data],
  :edit_uri => $Variables.command_uri(
      Command::Edit.base_name, node.escaped_name ),
  :lookback_uri => $Variables.command_uri(
      Command::Lookback.base_name, node.escaped_name ),
  :editinformation_uri => $Variables.command_uri(
      Command::Edit.base_name, information_node.escaped_name ),
  :help_uri => $Variables.command_uri(
      Command::Show.base_name, CGI.escape( $Variables.help_name ) ),
  :training_uri => $Variables.command_uri(
      Command::Show.base_name, CGI.escape( $Variables.training_name ) ),
  :recency_uri => $Variables.command_uri(
      Command::Show.base_name, CGI.escape( $Variables.recency_name ) ),
}
content_body = command.execute( node )
print $Variables.http_header
if node.container?
  print content_body
else
  s = ""
  $Variables.content_set[:content] = Amrita::SanitizedString[content_body]
  template.expand( s, $Variables.content_set )
  print s
end
