#define DEBUG
#undef DEBUG

#ifdef DEBUG
#define X(val)																													\
	do {																																	\
		fprintf(stderr, "%16s %4d %24s %32s: (%x)\n",												\
						__FILE__, __LINE__, __func__, #val, val);										\
		fflush(stderr);																											\
	} while (0)
#define C(val)																													\
	do {																																	\
		fprintf(stderr, "%16s %4d %24s %32s: (%c)\n",												\
						__FILE__, __LINE__, __func__, #val, val);										\
		fflush(stderr);																											\
	} while (0)
#define D(val)																													\
	do {																																	\
		fprintf(stderr, "%16s %4d %24s %32s: (%d)\n",												\
						__FILE__, __LINE__, __func__, #val, val);										\
		fflush(stderr);																											\
	} while (0)
#define P(val)																													\
	do {																																	\
		fprintf(stderr, "%16s %4d %24s %32s: (%p)\n",												\
						__FILE__, __LINE__, __func__, #val, val);										\
		fflush(stderr);																											\
	} while (0)
#define L(val)																													\
	do {																																	\
		fprintf(stderr, "%16s %4d %24s %32s: (%ld)\n",											\
						__FILE__, __LINE__, __func__, #val, val);										\
		fflush(stderr);																											\
	} while (0)
#define LL(val)																													\
	do {																																	\
		fprintf(stderr, "%16s %4d %24s %32s: (%lld)\n",											\
						__FILE__, __LINE__, __func__, #val, val);										\
		fflush(stderr);																											\
	} while (0)
#define S(val)																				\
	do {																								\
		fprintf(stderr, "%16s %4d %24s %32s: (%s)\n",			\
						__FILE__, __LINE__, __func__, #val, val); \
		fflush(stderr);																		\
	} while (0)
#define F(val)																													\
	do {																																	\
		fprintf(stderr, "%16s %4d %24s %32s: (%f)\n",												\
						__FILE__, __LINE__, __func__, #val, val);										\
		fflush(stderr);																											\
	} while (0)
#define N																															\
	do {																																\
		fprintf(stderr, "%16s %4d %24s\n",																\
						__FILE__, __LINE__, __func__);														\
		fflush(stderr);																										\
	} while (0)
#define ERR \
	do {							 \
		perror("ERROR"); \
		N;							 \
		exit(1);				 \
	} while (0)
#else
#define X(val)	do {} while (0);
#define C(val)	do {} while (0);
#define D(val)	do {} while (0);
#define P(val)	do {} while (0);
#define L(val)	do {} while (0);
#define LL(val)	do {} while (0);
#define S(val)	do {} while (0);
#define F(val)	do {} while (0);
#define N	do {} while (0);
#define ERR	do {} while (0);
#endif /* DEBUG */
