/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.common.ConstSqlTypes;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.sql.ColumnInfo;
import jdbcacsess.sql.column.Binary;
import jdbcacsess.sql.column.BinaryInputStream;
import jdbcacsess.sql.column.CharacterInputStream;

public abstract class PrepareExecute {
    protected ArrayList<PrepareExecuteParm> parmList;
    protected PreparedStatement prepared = null;
    protected StringBuffer statement = new StringBuffer();

    public PrepareExecute() {
        this.parmList = new ArrayList();
    }

    public void addStm(String stm) {
        this.statement.append(stm);
    }

    public String getStm() {
        return this.statement.toString();
    }

    public void addParm(Object value, ColumnInfo columnInfo) {
        this.parmList.add(new PrepareExecuteParm(value, columnInfo));
    }

    public void addParm(int idx, Object value, ColumnInfo columnInfo) {
        this.parmList.add(new PrepareExecuteParm(idx, value, columnInfo));
    }

    public abstract void prepare(Connection var1) throws SQLException;

    final void setParm() throws SQLException {
        int i = 0;
        while (i < this.parmList.size()) {
            int idx;
            PrepareExecuteParm pep = this.parmList.get(i);
            Object value = pep.x;
            ConstSqlTypes sqlMappingSqlType = pep.columnInfo.getSqlMappingSqlType();
            int n = idx = this.parmList.get((int)i).idx == 0 ? i + 1 : pep.idx;
            if (value == null) {
                if (sqlMappingSqlType == ConstSqlTypes.UNUSE) {
                    this.msg("setNull(" + idx + "," + pep.columnInfo.getSqlTypeInt() + ")");
                    this.prepared.setNull(idx, pep.columnInfo.getSqlTypeInt());
                } else {
                    this.msg("setNull(" + idx + "," + (Object)((Object)sqlMappingSqlType) + ")");
                    this.prepared.setNull(idx, sqlMappingSqlType.getValue());
                }
            } else if (value instanceof BinaryInputStream) {
                BinaryInputStream bis = (BinaryInputStream)value;
                this.msg("setBinaryStream(," + idx + "," + bis.getInputStream().getClass() + "," + bis.getSize() + ")");
                this.prepared.setBinaryStream(idx, bis.getInputStream(), bis.getSize());
            } else if (value instanceof CharacterInputStream) {
                CharacterInputStream cis = (CharacterInputStream)value;
                this.msg("setCharacterStream(," + idx + "," + cis.getReader().getClass() + "," + cis.getSize() + ")");
                this.prepared.setCharacterStream(idx, cis.getReader(), cis.getSize());
            } else if (value instanceof Binary) {
                this.msg("setBytes(," + idx + "," + ((Binary)value).getValue().getClass() + ")");
                this.prepared.setBytes(idx, ((Binary)value).getValue());
            } else if (sqlMappingSqlType == ConstSqlTypes.UNUSE) {
                this.msg("setObject(," + idx + "," + value.getClass() + ")");
                this.prepared.setObject(idx, value);
            } else {
                this.msg("setObject(," + idx + "," + value.getClass() + "," + (Object)((Object)sqlMappingSqlType) + ")");
                this.prepared.setObject(idx, value, sqlMappingSqlType.getValue());
            }
            ++i;
        }
        if (JFrameMain.debugMode) {
            StringBuilder sb = new StringBuilder("PrepareExecute:" + this.statement + " [");
            for (PrepareExecuteParm o : this.parmList) {
                sb.append(o.x == null ? "null" : o.x.toString());
                sb.append(",");
            }
            sb.append("]\n");
            JFrameMain.getInstanceJPanelPrepareStatementLog().appendLog(sb);
        }
    }

    final void clearParm() throws SQLException {
        for (PrepareExecuteParm item : this.parmList) {
            if (item instanceof BinaryInputStream) {
                BinaryInputStream bis = (BinaryInputStream)((Object)item);
                try {
                    bis.getInputStream().close();
                }
                catch (IOException e) {
                    JDialogMessage.errorDialog(e);
                }
            }
            if (!(item instanceof CharacterInputStream)) continue;
            CharacterInputStream cis = (CharacterInputStream)((Object)item);
            try {
                cis.getReader().close();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
        this.parmList.clear();
    }

    public void close() throws SQLException {
        if (this.prepared != null) {
            this.prepared.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHavingInputParameter() {
        try {
            ParameterMetaData pmd = this.prepared.getParameterMetaData();
            if (pmd == null) {
                return false;
            }
            int i = 1;
            while (true) {
                if (i >= pmd.getParameterCount() + 1) {
                    return false;
                }
                if (pmd.getParameterMode(i) == 1) return true;
                if (pmd.getParameterMode(i) == 2) {
                    return true;
                }
                ++i;
            }
        }
        catch (Error e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public PreparedStatement getPrepared() {
        return this.prepared;
    }

    void msg(String m) {
        if (JFrameMain.debugMode) {
            JFrameMain.getInstanceJPanelPrepareStatementLog().appendLog(String.valueOf(m) + "\n");
        }
    }

    class PrepareExecuteParm {
        int idx;
        Object x;
        ColumnInfo columnInfo;

        public PrepareExecuteParm(Object x, ColumnInfo columnInfo) {
            this.idx = 0;
            this.x = x;
            this.columnInfo = columnInfo;
        }

        public PrepareExecuteParm(int idx, Object x, ColumnInfo columnInfo) {
            this.idx = idx;
            this.x = x;
            this.columnInfo = columnInfo;
        }
    }
}

