/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import jdbcacsess.gui.JPanelExecSql;
import jdbcacsess.gui.SqlStatementObserver;
import jdbcacsess.gui.TabWinMode;

public class TabWinManager {
    private Vector<JPanel> jPanelList = null;
    private Pane pane;
    private SqlStatementObserver sqlStatementObserver;
    private int tabCount = 0;

    public TabWinManager(SqlStatementObserver sqlStatementObserver) {
        this.sqlStatementObserver = sqlStatementObserver;
        this.jPanelList = new Vector();
        this.newJComponentPane(TabWinMode.TAB);
        int i = 0;
        while (i < 4) {
            this.newPanel(true);
            ++i;
        }
    }

    private JComponent newJComponentPane(TabWinMode tabWin) {
        this.pane = tabWin == TabWinMode.TAB ? new PaneTab() : new PaneWin();
        return this.pane.newJComponentPane();
    }

    public void newPanel(boolean antoCommit) {
        JPanelExecSql pes = new JPanelExecSql(Integer.toString(++this.tabCount), antoCommit);
        this.addPanel(pes);
    }

    public void addPanel(JPanel panel) {
        this.jPanelList.add(panel);
        this.pane.addJPanel(panel);
    }

    public void allDisconnect() {
        for (JPanel panel : this.jPanelList) {
            if (!(panel instanceof JPanelExecSql)) continue;
            JPanelExecSql pes = (JPanelExecSql)panel;
            pes.disconnect();
        }
    }

    public void allPaneClosed() {
        this.allDisconnect();
        int i = this.jPanelList.size() - 1;
        while (i > -1) {
            this.disposePanel(this.jPanelList.get(i));
            --i;
        }
    }

    public void disposePanel(JPanel panel) {
        this.pane.removePanel(panel);
        this.jPanelList.remove(panel);
    }

    public JComponent changeTabWin(TabWinMode tw) {
        if (this.pane.isTabWinModeEqual(tw)) {
            return this.pane.getJComponentPane();
        }
        JPanel selectedPanel = this.pane.getSelectedJPanel();
        this.newJComponentPane(tw);
        for (JPanel item : this.jPanelList) {
            this.pane.addJPanel(item);
        }
        this.pane.getJComponentPane().setVisible(true);
        this.pane.setSelectPanel(selectedPanel);
        return this.pane.getJComponentPane();
    }

    public int getExecSqlListCnt() {
        int cnt = 0;
        for (JPanel item : this.jPanelList) {
            if (!(item instanceof JPanelExecSql)) continue;
            ++cnt;
        }
        return cnt;
    }

    public Pane getPane() {
        return this.pane;
    }

    public void sortWindow() {
        this.pane.sortWindow();
    }

    abstract class Pane {
        Pane() {
        }

        abstract void addJPanel(JPanel var1);

        abstract JComponent getJComponentPane();

        abstract JPanel getSelectedJPanel();

        abstract boolean isTabWinModeEqual(TabWinMode var1);

        abstract JComponent newJComponentPane();

        abstract void removePanel(JPanel var1);

        abstract void setPaneTitleName(JPanel var1, String var2);

        abstract void setSelectPanel(JPanel var1);

        abstract void sortWindow();
    }

    class PaneTab
    extends Pane {
        private JTabbedPane jTabbedPane = null;

        PaneTab() {
        }

        void addJPanel(JPanel panel) {
            this.jTabbedPane.addTab(panel.getName(), panel);
        }

        JComponent getJComponentPane() {
            return this.jTabbedPane;
        }

        JPanel getSelectedJPanel() {
            return (JPanel)this.jTabbedPane.getSelectedComponent();
        }

        boolean isTabWinModeEqual(TabWinMode tw) {
            return tw == TabWinMode.TAB;
        }

        JComponent newJComponentPane() {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setFont(new Font("Dialog", 0, 12));
            this.jTabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    Component c = PaneTab.this.jTabbedPane.getSelectedComponent();
                    if (c != null) {
                        if (c instanceof JPanelExecSql) {
                            JPanelExecSql pes = (JPanelExecSql)c;
                            TabWinManager.this.sqlStatementObserver.sqlStatementNotifyObservers(pes.getSqlStatement());
                        } else {
                            TabWinManager.this.sqlStatementObserver.sqlStatementNotifyObservers(null);
                        }
                    }
                }
            });
            return this.jTabbedPane;
        }

        void removePanel(JPanel panel) {
            if (panel == null) {
                return;
            }
            this.jTabbedPane.remove(panel);
        }

        void setPaneTitleName(JPanel pane, String panelTitlename) {
            int idx = this.jTabbedPane.indexOfComponent(pane);
            if (idx != -1) {
                this.jTabbedPane.setTitleAt(idx, panelTitlename);
                this.jTabbedPane.revalidate();
            }
        }

        void setSelectPanel(JPanel panel) {
            if (panel == null) {
                return;
            }
            this.jTabbedPane.setSelectedComponent(panel);
        }

        void sortWindow() {
        }
    }

    class PaneWin
    extends Pane {
        private JDesktopPane jDesktopPane = null;
        private HashMap<JInternalFrame, JPanel> jPanelExecSqlMap = null;
        int x = 0;
        int y = 0;

        PaneWin() {
        }

        void addJPanel(JPanel panel) {
            JInternalFrame jif = this.getJInternalFrame(panel);
            jif.setLocation(this.x, this.y);
            this.x += 15;
            this.y += 25;
            this.jDesktopPane.add(jif);
        }

        JComponent getJComponentPane() {
            return this.jDesktopPane;
        }

        private JInternalFrame getJInternalFrame(JPanel panel) {
            JInternalFrame jInternalFrame = new JInternalFrame();
            jInternalFrame.add(panel);
            jInternalFrame.setTitle(panel.getName());
            jInternalFrame.setLocation(new Point(0, 0));
            jInternalFrame.setSize(panel.getPreferredSize());
            jInternalFrame.setIconifiable(true);
            jInternalFrame.setResizable(true);
            jInternalFrame.setMaximizable(true);
            jInternalFrame.setVisible(true);
            this.jPanelExecSqlMap.put(jInternalFrame, panel);
            jInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameActivated(InternalFrameEvent e) {
                    JPanel panel = (JPanel)PaneWin.this.jPanelExecSqlMap.get(e.getInternalFrame());
                    if (panel instanceof JPanelExecSql) {
                        JPanelExecSql pes = (JPanelExecSql)panel;
                        TabWinManager.this.sqlStatementObserver.sqlStatementNotifyObservers(pes.getSqlStatement());
                    } else {
                        TabWinManager.this.sqlStatementObserver.sqlStatementNotifyObservers(null);
                    }
                }
            });
            return jInternalFrame;
        }

        JPanel getSelectedJPanel() {
            JInternalFrame jif = this.jDesktopPane.getSelectedFrame();
            if (jif == null) {
                return null;
            }
            return this.jPanelExecSqlMap.get(jif);
        }

        boolean isTabWinModeEqual(TabWinMode tw) {
            return tw == TabWinMode.WIN;
        }

        JComponent newJComponentPane() {
            this.jDesktopPane = new JDesktopPane();
            this.jPanelExecSqlMap = new HashMap();
            this.x = 0;
            this.y = 0;
            return this.jDesktopPane;
        }

        void removePanel(JPanel panel) {
            if (panel == null) {
                return;
            }
            JInternalFrame jif = this.searchParentFrame(panel);
            if (jif != null) {
                jif.dispose();
                this.jPanelExecSqlMap.remove(jif);
            }
        }

        private JInternalFrame searchParentFrame(JPanel panel) {
            for (Map.Entry<JInternalFrame, JPanel> map : this.jPanelExecSqlMap.entrySet()) {
                if (map.getValue() != panel) continue;
                return map.getKey();
            }
            return null;
        }

        void setPaneTitleName(JPanel panel, String panelTitlename) {
            JInternalFrame jif = this.searchParentFrame(panel);
            if (jif != null) {
                jif.setTitle(panelTitlename);
            }
        }

        void setSelectPanel(JPanel panel) {
            if (panel == null) {
                return;
            }
            JInternalFrame jif = this.searchParentFrame(panel);
            if (jif != null) {
                jif.toFront();
            }
        }

        void sortWindow() {
            Dimension dim = this.jDesktopPane.getSize();
            int sizeList = 0;
            JInternalFrame[] jInternalFrameArray = this.jDesktopPane.getAllFrames();
            int n = 0;
            int n2 = jInternalFrameArray.length;
            while (n < n2) {
                JInternalFrame jif = jInternalFrameArray[n];
                if (!jif.isIcon()) {
                    ++sizeList;
                }
                ++n;
            }
            int cntWidth = (int)Math.ceil((double)sizeList / Math.ceil(Math.sqrt(sizeList)));
            int cntHeight = (int)Math.ceil(Math.sqrt(sizeList));
            int winWidth = (int)dim.getWidth() / cntWidth;
            int winHeight = (int)dim.getHeight() / cntHeight;
            ArrayList<Point> points = new ArrayList<Point>();
            int width = 0;
            while (width < cntWidth) {
                int height = 0;
                while (height < cntHeight) {
                    Point p = new Point(winWidth * width, winHeight * height);
                    points.add(p);
                    ++height;
                }
                ++width;
            }
            Iterator it = points.iterator();
            JInternalFrame[] jInternalFrameArray2 = this.jDesktopPane.getAllFrames();
            int n3 = 0;
            int n4 = jInternalFrameArray2.length;
            while (n3 < n4) {
                JInternalFrame jif = jInternalFrameArray2[n3];
                if (!jif.isIcon()) {
                    jif.setSize(new Dimension(winWidth, winHeight));
                    jif.setLocation((Point)it.next());
                }
                ++n3;
            }
            this.x = 0;
            this.y = 0;
        }
    }
}

