/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import jdbcacsess.JdbcacsessException;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvInput;
import jdbcacsess.gui.common.ConstItemHeader;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JFrameBase;

public class CsvInputDataView
extends CsvInput {
    private JFrame jFrame = null;
    private JTable jTable = null;
    Vector<String> columnNames;
    Vector<Vector<String>> rowDatas;
    int maxColumnCnt;

    public CsvInputDataView(CsvInfo info) {
        super(info);
        if (!this.load()) {
            return;
        }
        this.jFrame = new JFrameCsvInputDataView(this.csvInfo.getFileName());
        this.jFrame.setVisible(true);
    }

    private boolean load() {
        try {
            this.openInputFile();
        }
        catch (JdbcacsessException e) {
            return false;
        }
        this.inputCnt = 0;
        try {
            try {
                this.getColumnNames();
                this.getRowData();
            }
            catch (JdbcacsessException e) {
                this.closeInputFile();
                return false;
            }
        }
        finally {
            this.closeInputFile();
        }
        if (this.columnNames.isEmpty() && !this.rowDatas.isEmpty()) {
            int i = 0;
            while (i < this.maxColumnCnt) {
                this.columnNames.add(new Integer(i).toString());
                ++i;
            }
        }
        boolean err = false;
        int cnt = this.maxColumnCnt - this.columnNames.size();
        int i = 0;
        while (i < cnt) {
            this.columnNames.add("\u25a0?\u25a0");
            err = true;
            ++i;
        }
        if (this.maxColumnCnt < this.columnNames.size()) {
            this.maxColumnCnt = this.columnNames.size();
        }
        for (Vector<String> rows : this.rowDatas) {
            cnt = this.maxColumnCnt - rows.size();
            int i2 = 0;
            while (i2 < cnt) {
                rows.add("\u25a0?\u25a0");
                err = true;
                ++i2;
            }
        }
        if (err) {
            JDialogMessage.errorDialog(new Exception("\u5148\u982d100\u4ef6\u4ee5\u5185\u306b\u30ab\u30e9\u30e0\u6570\u304c\u4e00\u81f4\u3057\u3066\u306a\u3044\u30c7\u30fc\u30bf\u304c\u3042\u308a\u307e\u3059\u3002\n\u53f3\u7aef\u306e\u300e\u25a0?\u25a0\u300f\u3092\u78ba\u8a8d\u3057\u3066\u4e0b\u3055\u3044\u3002\n\u3057\u3064\u3053\u3044\u3067\u3059\u304c\u3001\u30d5\u30a1\u30a4\u30eb\u5168\u4f53\u306f\u30c1\u30a7\u30c3\u30af\u3057\u3066\u307e\u305b\u3093\u3002"));
        }
        return true;
    }

    private void getRowData() throws JdbcacsessException {
        this.rowDatas = new Vector();
        try {
            while (this.inputCnt <= 100) {
                Vector<String> rowData = this.readFile();
                if (rowData != null) {
                    if (this.maxColumnCnt < rowData.size()) {
                        this.maxColumnCnt = rowData.size();
                    }
                    this.rowDatas.add(rowData);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            JDialogMessage.errorDialog(e);
            throw new JdbcacsessException(e);
        }
    }

    private void getColumnNames() throws JdbcacsessException {
        if (this.csvInfo.getItemHeader() == ConstItemHeader.TRUE) {
            try {
                this.columnNames = this.readFile();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
                throw new JdbcacsessException(e);
            }
            if (this.columnNames == null) {
                Exception e = new Exception("\u898b\u51fa\u3057\u6709\u308a\u306a\u306e\u306b\u3001\u7a7a\u30d5\u30a1\u30a4\u30eb\u3067\u3059");
                JDialogMessage.errorDialog(e);
                throw new JdbcacsessException(e);
            }
        } else {
            this.columnNames = new Vector();
        }
    }

    private void actionPerfromedReLoad() {
        if (!this.load()) {
            return;
        }
        this.jTable.setModel(new DefaultTableModel(this.rowDatas, this.columnNames));
    }

    public class JFrameCsvInputDataView
    extends JFrameBase {
        private static final long serialVersionUID = 2655462988366965325L;
        private JPanel jContentPane = null;
        private JPanel jPanelMain = null;
        private JScrollPane jScrollPane = null;
        private JPanel jPanel1 = null;
        private JButton jButtonReLoad = null;

        private JFrameCsvInputDataView(String title) {
            this.initialize();
            this.setTitle(title);
        }

        public void initialize() {
            this.setSize(new Dimension(400, 200));
            this.setContentPane(this.getJContentPane());
            this.init();
        }

        private JPanel getJContentPane() {
            if (this.jContentPane == null) {
                this.jContentPane = new JPanel();
                this.jContentPane.setLayout(new BorderLayout());
                this.jContentPane.add((Component)this.getJPanelMain(), "Center");
                this.jContentPane.add((Component)this.getJPanel1(), "South");
            }
            return this.jContentPane;
        }

        private JPanel getJPanelMain() {
            if (this.jPanelMain == null) {
                this.jPanelMain = new JPanel();
                this.jPanelMain.setLayout(new BorderLayout());
                this.jPanelMain.add((Component)this.getJScrollPane(), "Center");
            }
            return this.jPanelMain;
        }

        private JScrollPane getJScrollPane() {
            if (this.jScrollPane == null) {
                this.jScrollPane = new JScrollPane();
                this.jScrollPane.setViewportView(this.getJTable());
            }
            return this.jScrollPane;
        }

        private JTable getJTable() {
            if (CsvInputDataView.this.jTable == null) {
                CsvInputDataView.this.jTable = new JTable(CsvInputDataView.this.rowDatas, CsvInputDataView.this.columnNames);
                CsvInputDataView.this.jTable.setAutoResizeMode(0);
                CsvInputDataView.this.jTable.setDefaultEditor(Object.class, null);
            }
            return CsvInputDataView.this.jTable;
        }

        private JPanel getJPanel1() {
            if (this.jPanel1 == null) {
                this.jPanel1 = new JPanel();
                this.jPanel1.add((Component)this.getJButtonReLoad(), null);
            }
            return this.jPanel1;
        }

        private JButton getJButtonReLoad() {
            if (this.jButtonReLoad == null) {
                this.jButtonReLoad = new JButton();
                this.jButtonReLoad.setText("\u518d\u8aad\u8fbc");
                this.jButtonReLoad.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CsvInputDataView.this.actionPerfromedReLoad();
                    }
                });
            }
            return this.jButtonReLoad;
        }
    }
}

