/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.tags.beans;

import java.util.LinkedList;
import java.util.List;

import shohaku.core.lang.Eval;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;
import shohaku.sugina.dynbind.BindArgumentDesc;
import shohaku.sugina.dynbind.BindArgumentsDesc;
import shohaku.sugina.dynbind.BindMethod;

/**
 * メソッドを拡張された規則で束縛するデータの値タグを提供します。shohaku.sugina.binder.BindMethod 型のデータを生成します。
 */
public class BindMethodTag extends AbstractValueTag {

    private Class clazz = null;

    private Object ref = null;

    private final List args = new LinkedList();

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        final String methodName = getName();

        if (Eval.isBlank(methodName)) {
            throw new GinkgoException("name is blank." + methodName);
        }

        Class objType = clazz;
        Object obj = null;

        // get bind class
        if (null == objType) {
            if (null == ref) {
                throw new GinkgoException("reference id doesn't exist.");
            }
            if (ref instanceof Class) {
                objType = (Class) ref;
                // obj = null;
            } else {
                objType = ref.getClass();
                obj = ref;
            }
        }

        BindArgumentDesc[] bindArguments = (BindArgumentDesc[]) args.toArray(new BindArgumentDesc[0]);

        // generate BindMethod
        try {
            return BindMethod.bind(methodName, objType, obj, new BindArgumentsDesc(bindArguments));
        } catch (IntrospectionBeansException e) {
            throw new GinkgoException("BindMethod binding error. " + e);
        }
    }

    /**
     * class 属性を格納します。
     * 
     * @param clazz
     *            class 属性
     */
    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    /**
     * ref 属性を格納します。
     * 
     * @param ref
     *            ref属性
     */
    public void setRef(Object ref) {
        this.ref = ref;
    }

    /**
     * clazz 属性を返却します。
     * 
     * @return clazz 属性
     */
    public Class getClazz() {
        return this.clazz;
    }

    /**
     * ref 属性を返却します。
     * 
     * @return ref 属性
     */
    public Object getRef() {
        return this.ref;
    }

    /**
     * エレメントを追加します。
     * 
     * @param arg
     *            エレメント
     */
    public void addElementTransferValue(BindArgumentDesc arg) {
        args.add(arg);
    }

}
