/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.resourceset;

import java.util.Map;

import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ObjectCreationProxy;
import shohaku.shoin.ResourceCreationException;

/**
 * shohaku.core.lang.ObjectCreationProxy から生成されたオブジェクトを値とするリソース集合を提供します。<br>
 * ObjectCreationProxy を値とするマップを内部表現とします。
 */
public class ObjectCreationProxyResourceSet extends MapResourceSet {

    /**
     * ObjectCreationProxy を値に持つマップを格納して初期化します。
     * 
     * @param beansFactorys
     *            ObjectCreationProxy を値に持つマップ
     */
    public ObjectCreationProxyResourceSet(Map beansFactorys) {
        super(beansFactorys);
    }

    /**
     * 指定の識別子を持つオブジェクトを生成して返却します。 <br>
     * 指定された識別子が存在しない場合は null を返却します。
     * 
     * @param id
     *            識別子
     * @return 指定の識別子を持つオブジェクト
     * @throws ResourceCreationException
     *             オブジェクトの生成に失敗した場合
     * @throws NullPointerException
     *             id が null の場合
     */
    public Object getObject(Object id) {
        if (id == null) {
            throw new NullPointerException("key is null.");
        }
        ObjectCreationProxy o = (ObjectCreationProxy) getResourceMap().get(id);
        if (o == null) {
            return null;
        }
        try {
            return o.create();
        } catch (ObjectCreationException e) {
            throw new ResourceCreationException("componentId is illegal. " + id, e);
        }
    }

}
