/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.factory;

import java.util.Iterator;
import java.util.Map;

import shohaku.core.lang.Eval;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.ValueNode;
import shohaku.shoin.ResourceSetFactoryProxy;

/**
 * ライブラリの集約機能のコンテキスト要素を生成するファクトリを提供します。<br>
 * これは、shohaku.shoin.Shoin が内部的に使用します、ユーザが直接に利用することは無いと思われます。
 */
public class ShoinContextFactory extends AbstractGinkgoResourceSetFactory {

    /**
     * プロパティを初期値で初期化します。
     */
    public ShoinContextFactory() {
        super();
    }

    protected void initValues(Map lookup, TagNode root, int index) throws GinkgoException {
        for (Iterator i = root.getTagContext().elementIterator("proxys"); i.hasNext();) {
            TagNode proxys = (TagNode) i.next();
            initProxys(proxys, lookup);
        }
    }

    /* プロシキの初期化および登録をする */
    private void initProxys(TagNode proxys, Map lookup) throws GinkgoException {
        for (Iterator i = proxys.getTagContext().elementIterator("proxy"); i.hasNext();) {
            TagNode proxy = (TagNode) i.next();
            String id = proxy.getId();
            if (Eval.isBlank(id)) {
                throw new GinkgoException("proxy id is null.");
            }
            Object _proxy = ((ValueNode) proxy).getNodeValue();
            if (!(_proxy instanceof ResourceSetFactoryProxy)) {
                throw new GinkgoException("proxy not as ResourceSetFactoryProxy.");
            }
            lookup.put(id, _proxy);
        }
    }

}