/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.factory;

import shohaku.core.resource.IOResource;
import shohaku.shoin.IOResourceSetFactory;

/**
 * IOリソースからリソース集合を生成するファクトリの抽象実装を提供します。
 */
public abstract class AbstractIOResourceSetFactory extends AbstractResourceSetFactory implements IOResourceSetFactory {

    /* IOリソース の配列 */
    private IOResource[] ioResources;

    /**
     * プロパティを初期値で初期化します。
     */
    public AbstractIOResourceSetFactory() {
        super();
    }

    public IOResource[] getIOResources() {
        return ioResources;
    }

    public void setIOResources(IOResource[] ioResources) {
        this.ioResources = ioResources;
    }

}
