/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.bundle;

import shohaku.core.resource.IOResource;
import shohaku.shoin.ResourceSet;
import shohaku.shoin.ResourceSetCreationException;
import shohaku.shoin.XResourceBundle;
import shohaku.shoin.XResourceBundleCreater;
import shohaku.shoin.XResourceBundleEvent;
import shohaku.shoin.factory.OgdlProperties;

/**
 * OgdlResourceBundle 用の階層化リソースバンドルを生成する機能を提供します。
 */
class OgdlResourceBundleCreater extends XResourceBundleCreater {

    /* OgdlResourceBundle の新規インスタンスを生成して返却します。 */
    public XResourceBundle createXResourceBundle(XResourceBundleEvent event) {

        OgdlProperties props = new OgdlProperties();
        props.setClassLoader(event.getClassLoader());
        props.setIOResources(new IOResource[] { event.getTargetIOResource() });

        try {

            ResourceSet resources = props.getResourceSet();
            return new OgdlResourceBundle(event.getTargetParent(), event.getTargetBundleBase(), resources);

        } catch (ResourceSetCreationException e) {
            return null;
        }
    }

}