/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.bundle;

import shohaku.ginkgo.Document;
import shohaku.ginkgo.DocumentCompositeRule;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.shoin.XResourceBundleEvent;

/**
 * Ginkgo API 用いた拡張可能な階層化リソースバンドルの生成イベントを提供します。
 */
public class GinkgoXResourceBundleEvent extends XResourceBundleEvent {

    /* serialVersionUID */
    private static final long serialVersionUID = -6051969788267373604L;

    /* 親ドキュメント */
    private Document targetParentDocument;

    /* ドキュメント構成ルール */
    private DocumentCompositeRule targetDocumentCompositeRule;

    /* ノード構成ルール */
    private NodeCompositeRule targetNodeCompositeRule;

    /**
     * プロパティの初期値 null でイベントを初期化します。
     * 
     * @param source
     *            処理の実行元
     */
    public GinkgoXResourceBundleEvent(Object source) {
        super(source);
    }

    /**
     * ドキュメント構成ルールを返却します。
     * 
     * @return ドキュメント構成ルール
     */
    public DocumentCompositeRule getTargetDocumentCompositeRule() {
        return targetDocumentCompositeRule;
    }

    /**
     * ドキュメント構成ルールを格納します。
     * 
     * @param docRule
     *            ドキュメント構成ルール
     */
    public void setTargetDocumentCompositeRule(DocumentCompositeRule docRule) {
        this.targetDocumentCompositeRule = docRule;
    }

    /**
     * ノード構成ルールを返却します。
     * 
     * @return ノード構成ルール
     */
    public NodeCompositeRule getTargetNodeCompositeRule() {
        return targetNodeCompositeRule;
    }

    /**
     * ノード構成ルールを格納します。
     * 
     * @param nodeRule
     *            ノード構成ルール
     */
    public void setTargetNodeCompositeRule(NodeCompositeRule nodeRule) {
        this.targetNodeCompositeRule = nodeRule;
    }

    /**
     * 親ドキュメントを返却します。
     * 
     * @return 親ドキュメント
     */
    public Document getTargetParentDocument() {
        return targetParentDocument;
    }

    /**
     * 親ドキュメントを格納します。
     * 
     * @param parentDoc
     *            親ドキュメント
     */
    public void setTargetParentDocument(Document parentDoc) {
        this.targetParentDocument = parentDoc;
    }

}
