/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.bundle;

import shohaku.core.resource.IOResource;
import shohaku.shoin.ResourceSet;
import shohaku.shoin.ResourceSetCreationException;
import shohaku.shoin.factory.BindMethodFactory;

class BindMethodResourceBundleCreater extends AbstractGinkgoXResourceBundleCreater {

    protected AbstractGinkgoXResourceBundle createGinkgoResourceBundle(GinkgoXResourceBundleEvent event) {

        BindMethodFactory factory = new BindMethodFactory();
        factory.setClassLoader(event.getClassLoader());
        factory.setParentDocument(event.getTargetParentDocument());
        factory.setDocumentCompositeRule(event.getTargetDocumentCompositeRule());
        factory.setNodeCompositeRule(event.getTargetNodeCompositeRule());
        factory.setIOResources(new IOResource[] { event.getTargetIOResource() });

        try {

            ResourceSet resources = factory.getResourceSet();
            return new BindMethodResourceBundle(event.getTargetParent(), event.getTargetBundleBase(), resources, factory.getParseDocument());

        } catch (ResourceSetCreationException e) {
            return null;
        }

    }

    protected Class getGinkgoResourceBundleClass() {
        return BindMethodResourceBundle.class;
    }
}