/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin;

import java.util.List;

/**
 * 拡張可能な階層化リソースバンドルのリソースを束ねるための束縛基準を定義する機能を提供します。<br>
 * 階層化リソースバンドルは、このインターフェースの実装に基づき階層化されます。<br>
 */
public interface XResourceBundleBase {

    /**
     * ルートの束縛基準である場合に true を返却します。
     * 
     * @return ルートの束縛基準である場合に true
     */
    boolean isRoot();

    /**
     * ルートの束縛基準を返却します。
     * 
     * @return ルートの束縛基準
     */
    XResourceBundleBase getRoot();

    /**
     * この束縛基準の識別子を返却します。
     * 
     * @return この束縛基準の識別子
     */
    String getBundleId();

    /**
     * リソースに対する、この束縛基準の接尾辞を返却します。
     * 
     * @return この束縛基準の接尾辞
     */
    String getResourceSuffix();

    /**
     * この束縛基準の上位の束縛基準をルートをトップとする階層順で返却します。
     * 
     * @return 上位の束縛基準のリスト
     */
    List getParents();

    /**
     * 束縛基準のハッシュコード値を返却します。<br>
     * 任意の束縛基準 t1 と t2 で t1.equals(t2) であれば、t1.hashCode()==t2.hashCode() となることが保証する必要があります。
     * 
     * @return 束縛基準のハッシュコード値
     * @see java.lang.Object#hashCode()
     */
    int hashCode();

    /**
     * 引数がこの束縛基準と同値の束縛基準として認識できるか検証します。
     * 
     * @param o
     *            比較するオブジェクト
     * @return 引数がこの束縛基準と同値の束縛基準の場合は true
     * @see java.lang.Object#equals(java.lang.Object)
     */
    boolean equals(Object o);

}
