/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.util.debug;

/**
 * 標準出力ストリームへ出力する DumpStream を使用した System.out の拡張機能を提供します。<br>
 * <br>
 * 簡易的なデバック文出力への利用を想定しており System.out.print() と同感覚で、より詳細な出力を得ることが出来ます。
 * 
 * @see shohaku.core.util.debug.DumpStream
 */
public class Dump {

    /** System.out に出力する DumpStream を提供します。 */
    public static final DumpStream out = new DumpStream(System.out, true);

    /** System.err に出力する DumpStream を提供します。 */
    public static final DumpStream err = new DumpStream(System.err, true);

}
