/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

/**
 * URLが示すリソースの入力ストリームを返す入力リソースを提供します。
 */
public class UrlInputResource implements InputResource {

    /** ファイル。 */
    private final URL url;

    /**
     * URL文字列からURLオブジェクトを作成して初期化します。
     * 
     * @param spec
     *            URL文字列
     * @throws MalformedURLException
     *             文字列に指定されたプロトコルが未知である場合
     */
    public UrlInputResource(String spec) throws MalformedURLException {
        this.url = new URL(spec);
    }

    /**
     * URLオブジェクトを格納して初期化します。
     * 
     * @param url
     *            URL
     */
    public UrlInputResource(URL url) {
        this.url = url;
    }

    /**
     * URLオブジェクトの入力ストリームを返却します。
     * 
     * @return 入力ストリーム
     * @throws IOException
     *             プロトコルが入力をサポートしていない場合等の障害
     * @see shohaku.core.resource.InputResource#getInputStream()
     */
    public InputStream getInputStream() throws IOException {
        URLConnection con = this.url.openConnection();
        con.setUseCaches(false);// キャッシュ不要
        return con.getInputStream();
    }

    public boolean exists() {
        try {
            InputStream is = getInputStream();
            is.close();
            return true;
        } catch (IOException e) {
            return false;
        }
    }

    public long getLastModified() throws IOException {
        URLConnection con = this.url.openConnection();
        con.setUseCaches(false);// キャッシュ不要
        return con.getLastModified();
    }

}