/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang.feature.impl;

import java.util.logging.Level;
import java.util.logging.Logger;

import shohaku.core.lang.feature.LogFeature;

/**
 * JDK Logging API を出力先とするログ機能を提供します。
 */
class JDKLogFeature implements LogFeature {

    private final Logger log;

    /**
     * JDK ログのインスタンスを格納して初期化します。
     * 
     * @param logger
     *            JDK ログ
     */
    public JDKLogFeature(Logger logger) {
        this.log = logger;
    }

    public boolean isTraceEnabled() {
        return log.isLoggable(Level.FINER);
    }

    public boolean isDebugEnabled() {
        return log.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return log.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return log.isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return log.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return log.isLoggable(Level.SEVERE);
    }

    public void trace(Object message) {
        log.log(Level.FINER, String.valueOf(message));
    }

    public void trace(Object message, Throwable t) {
        log.log(Level.FINER, String.valueOf(message), t);
    }

    public void debug(Object message) {
        log.log(Level.FINE, String.valueOf(message));
    }

    public void debug(Object message, Throwable t) {
        log.log(Level.FINE, String.valueOf(message), t);
    }

    public void info(Object message) {
        log.log(Level.INFO, String.valueOf(message));
    }

    public void info(Object message, Throwable t) {
        log.log(Level.INFO, String.valueOf(message), t);
    }

    public void warn(Object message) {
        log.log(Level.WARNING, String.valueOf(message));
    }

    public void warn(Object message, Throwable t) {
        log.log(Level.WARNING, String.valueOf(message), t);
    }

    public void error(Object message) {
        log.log(Level.SEVERE, String.valueOf(message));
    }

    public void error(Object message, Throwable t) {
        log.log(Level.SEVERE, String.valueOf(message), t);
    }

    public void fatal(Object message) {
        log.log(Level.SEVERE, String.valueOf(message));
    }

    public void fatal(Object message, Throwable t) {
        log.log(Level.SEVERE, String.valueOf(message), t);
    }

}