/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang;

/**
 * 数値型の範囲を表す機能のインターフェースを提供します。<br>
 * この実装クラスは、不変オブジェクトとして定義します。
 */
public interface RangeNumber extends java.io.Serializable {

    /**
     * 最大値を返却します。
     * 
     * @return 最大値
     */
    Number getMaxValue();

    /**
     * 最小値を返却します。
     * 
     * @return 最小値
     */
    Number getMinValue();
}
