/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang;

/**
 * オブジェクトに対するイントロスペクション処理に失敗した場合に発生します。 <br>
 * <br>
 * SecurityException や NoSuchMethodException 等のイントロスペクション処理時に発生する例外の一般化された例外として定義されています。 <br>
 * 例外の原因は可能な限り起因例外に含まれる事が要求されます。
 */
public class IntrospectionBeansException extends Exception {

    /* serialVersionUID */
    private static final long serialVersionUID = 8575189342738911875L;

    /**
     * デフォルトコンストラクタ。
     */
    public IntrospectionBeansException() {
        super();
    }

    /**
     * エラーメッセージを設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     */
    public IntrospectionBeansException(String message) {
        super(message);
    }

    /**
     * 起因例外を設定して初期化します。
     * 
     * @param cause
     *            起因例外
     */
    public IntrospectionBeansException(Throwable cause) {
        super(cause);
    }

    /**
     * エラーメッセージと起因例外を設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     * @param cause
     *            起因例外
     */
    public IntrospectionBeansException(String message, Throwable cause) {
        super(message, cause);
    }

}
