/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.helpers;

/**
 * コード変換するヘルパーメソッド群を提供します。
 */
public class HCoder {

    /**
     * Unicode escapes の文字表現を文字列へ変換して返却します。
     * 
     * @param src
     *            変換基の文字列
     * @return 変換後の文字列
     */
    public static String decodeUnicodeEscapes(CharSequence src) {
        return UnicodeEscapesCoder.decode(src);
    }

    /**
     * 文字列を Unicode escapes の文字表現に変換して返却します。
     * 
     * @param src
     *            変換基の文字列
     * @return 変換後の文字列
     */
    public static String encodeUnicodeEscapes(CharSequence src) {
        return UnicodeEscapesCoder.decode(src);
    }

    /**
     * プロパティ用の Unicode escapes の文字表現を文字列へ変換して返却します。
     * 
     * @param src
     *            変換基の文字列
     * @return 変換後の文字列
     */
    public static String decodePropertiesEscapes(CharSequence src) {
        return PropertiesEscapesCoder.decode(src);
    }

    /**
     * 文字列をプロパティ用の Unicode escapes の文字表現に変換して返却します。
     * 
     * @param src
     *            変換基の文字列
     * @return 変換後の文字列
     */
    public static String encodePropertiesEscapes(CharSequence src) {
        return PropertiesEscapesCoder.decode(src);
    }

}
