/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * パッケージ内の共通定数を提供します。
 */
class Constants {

    /** クラスの空配列 */
    static final Class[] EMPTY_CLASSES = new Class[0];

    /** オブジェクトの空配列 */
    static final Object[] EMPTY_OBJECTS = new Object[0];

    /** デフォルトの日時とミリ秒のフォーマット。 */
    static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    /** デフォルトで有効な日付フォーマットの配列。 */
    static final List DATETIME_FORMAT_LIST;
    static {
        // 書式が競合するため、長い書式を前方に定義します
        List l = new ArrayList();
        l.add("yyyy-MM-dd HH:mm:ss.SSS");
        l.add("yyyy-MM-dd HH:mm:ss.SS");
        l.add("yyyy-MM-dd HH:mm:ss.S");
        l.add("yyyy-MM-dd HH:mm:ss");
        l.add("yyyy-MM-dd HH:mm");
        l.add("yyyy-MM-dd HH");
        l.add("yyyy-MM-dd");
        l.add("yyyy-MM");
        l.add("yyyy");
        l.add("HH:mm:ss.SSS");
        l.add("HH:mm:ss.SS");
        l.add("HH:mm:ss.S");
        l.add("HH:mm:ss");
        l.add("HH:mm");
        DATETIME_FORMAT_LIST = Collections.unmodifiableList(l);
    }

}
