/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.functor;

/**
 * ファンクタの処理中に障害が発生した事を通知する機能を提供します。<br>
 * <br>
 * 例外の原因は可能な限り起因例外に含まれる事が要求されます。
 */
public class FunctorException extends RuntimeException {

    /* serialVersionUID */
    private static final long serialVersionUID = 8425524068276135144L;

    /**
     * デフォルトコンストラクタ。
     */
    public FunctorException() {
        super();
    }

    /**
     * エラーメッセージを設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     */
    public FunctorException(String message) {
        super(message);
    }

    /**
     * 起因例外を設定して初期化します。
     * 
     * @param cause
     *            起因例外
     */
    public FunctorException(Throwable cause) {
        super(cause);
    }

    /**
     * エラーメッセージと起因例外を設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     * @param cause
     *            起因例外
     */
    public FunctorException(String message, Throwable cause) {
        super(message, cause);
    }
}
